/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.WorkFlowLineageService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkFlowLineage;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="WORK_FLOW_LINEAGE_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/lineages"})
public class WorkFlowLineageController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowLineageController.class);
    @Autowired
    private WorkFlowLineageService workFlowLineageService;

    @Operation(summary="queryLineageByWorkFlowName", description="QUERY_WORKFLOW_LINEAGE_BY_NAME_NOTES")
    @GetMapping(value={"/query-by-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_LINEAGE_ERROR)
    public Result<List<WorkFlowLineage>> queryWorkFlowLineageByName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workFlowName", required=false) String workFlowName) {
        workFlowName = ParameterUtils.handleEscapes((String)workFlowName);
        List<WorkFlowLineage> workFlowLineages = this.workFlowLineageService.queryWorkFlowLineageByName(projectCode, workFlowName);
        return Result.success(workFlowLineages);
    }

    @Operation(summary="queryLineageByWorkFlowCode", description="QUERY_WORKFLOW_LINEAGE_BY_CODE_NOTE")
    @GetMapping(value={"/{workFlowCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_LINEAGE_ERROR)
    public Result<Map<String, Object>> queryWorkFlowLineageByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="workFlowCode", required=true) long workFlowCode) {
        Map<String, Object> result = this.workFlowLineageService.queryWorkFlowLineageByCode(projectCode, workFlowCode);
        return Result.success(result);
    }

    @Operation(summary="queryWorkFlowList", description="QUERY_WORKFLOW_LINEAGE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result<Map<String, Object>> queryWorkFlowLineage(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        try {
            Map<String, Object> result = this.workFlowLineageService.queryWorkFlowLineage(projectCode);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            log.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getCode(), Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg());
        }
    }

    @Operation(summary="verifyTaskCanDelete", description="VERIFY_TASK_CAN_DELETE")
    @Parameters(value={@Parameter(name="projectCode", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskCode", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789"))})
    @PostMapping(value={"/tasks/verify-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_WITH_DEPENDENT_ERROR)
    public Result verifyTaskCanDelete(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode", required=true) long processDefinitionCode, @RequestParam(value="taskCode", required=true) long taskCode) {
        Result result = new Result();
        Optional<String> taskDepMsg = this.workFlowLineageService.taskDepOnTaskMsg(projectCode, processDefinitionCode, taskCode);
        if (taskDepMsg.isPresent()) {
            throw new ServiceException(taskDepMsg.get());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

