/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleCreateRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleFilterRequest;
import org.apache.dolphinscheduler.api.dto.schedule.ScheduleUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SCHEDULER_TAG")
@RestController
@RequestMapping(value={"/v2/schedules"})
public class ScheduleV2Controller
extends BaseController {
    @Autowired
    private SchedulerService schedulerService;

    @Operation(summary="create", description="CREATE_SCHEDULE_NOTES")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_SCHEDULE_ERROR)
    public Result<Schedule> createSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody ScheduleCreateRequest scheduleCreateRequest) {
        Schedule schedule = this.schedulerService.createSchedulesV2(loginUser, scheduleCreateRequest);
        return Result.success(schedule);
    }

    @Operation(summary="delete", description="DELETE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="id", description="SCHEDULE_ID", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_SCHEDULE_BY_ID_ERROR)
    public Result deleteSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id) {
        this.schedulerService.deleteSchedulesById(loginUser, id);
        return Result.success();
    }

    @Operation(summary="update", description="UPDATE_SCHEDULE_NOTES")
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_SCHEDULE_ERROR)
    public Result<Schedule> updateSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id, @RequestBody ScheduleUpdateRequest scheduleUpdateRequest) {
        Schedule schedule = this.schedulerService.updateSchedulesV2(loginUser, id, scheduleUpdateRequest);
        return Result.success(schedule);
    }

    @Operation(summary="get", description="GET_SCHEDULE_BY_ID_NOTES")
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_ERROR)
    public Result<Schedule> getSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id) {
        Schedule schedule = this.schedulerService.getSchedule(loginUser, id);
        return Result.success(schedule);
    }

    @Operation(summary="get", description="QUERY_SCHEDULE_LIST_PAGING_NOTES")
    @PostMapping(value={"/filter"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_PAGING_ERROR)
    public Result<PageInfo<Schedule>> filterSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody ScheduleFilterRequest scheduleFilterRequest) {
        PageInfo<Schedule> schedules = this.schedulerService.filterSchedules(loginUser, scheduleFilterRequest);
        return Result.success(schedules);
    }
}

