/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.workflow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.PageQueryDto;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;

@Schema(name="WORKFLOW-QUERY")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkflowFilterRequest
extends PageQueryDto {
    @Schema(example="project-name")
    private String projectName;
    @Schema(example="workflow-name")
    private String workflowName;
    @Schema(example="ONLINE / OFFLINE")
    private String releaseState;
    @Schema(example="ONLINE / OFFLINE")
    private String scheduleReleaseState;

    public ProcessDefinition convert2ProcessDefinition() {
        ProcessDefinition processDefinition = new ProcessDefinition();
        if (this.workflowName != null) {
            processDefinition.setName(this.workflowName);
        }
        if (this.releaseState != null) {
            processDefinition.setReleaseState(ReleaseState.valueOf((String)this.releaseState));
        }
        return processDefinition;
    }

    @Generated
    public WorkflowFilterRequest() {
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public String getScheduleReleaseState() {
        return this.scheduleReleaseState;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setScheduleReleaseState(String scheduleReleaseState) {
        this.scheduleReleaseState = scheduleReleaseState;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowFilterRequest)) {
            return false;
        }
        WorkflowFilterRequest other = (WorkflowFilterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$workflowName = this.getWorkflowName();
        String other$workflowName = other.getWorkflowName();
        if (this$workflowName == null ? other$workflowName != null : !this$workflowName.equals(other$workflowName)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$scheduleReleaseState = this.getScheduleReleaseState();
        String other$scheduleReleaseState = other.getScheduleReleaseState();
        return !(this$scheduleReleaseState == null ? other$scheduleReleaseState != null : !this$scheduleReleaseState.equals(other$scheduleReleaseState));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowFilterRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $workflowName = this.getWorkflowName();
        result = result * 59 + ($workflowName == null ? 43 : $workflowName.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $scheduleReleaseState = this.getScheduleReleaseState();
        result = result * 59 + ($scheduleReleaseState == null ? 43 : $scheduleReleaseState.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowFilterRequest(projectName=" + this.getProjectName() + ", workflowName=" + this.getWorkflowName() + ", releaseState=" + this.getReleaseState() + ", scheduleReleaseState=" + this.getScheduleReleaseState() + ")";
    }
}

