/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery;

import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryResult;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.service.command.CommandService;

public class FailureRecoveryExecuteFunction
implements ExecuteFunction<FailureRecoveryRequest, FailureRecoveryResult> {
    private final CommandService commandService;

    public FailureRecoveryExecuteFunction(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public FailureRecoveryResult execute(FailureRecoveryRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().isFailure()) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, can not be recovered", workflowInstance.getName(), workflowInstance.getState()));
        }
        Command command = Command.builder().commandType(CommandType.START_FAILURE_TASK_PROCESS).processDefinitionCode(workflowInstance.getProcessDefinitionCode().longValue()).processDefinitionVersion(workflowInstance.getProcessDefinitionVersion()).processInstanceId(workflowInstance.getId().intValue()).executorId(request.getExecuteUser().getId().intValue()).testFlag(workflowInstance.getTestFlag()).build();
        if (this.commandService.createCommand(command) <= 0) {
            throw new ExecuteRuntimeException("Failure recovery workflow instance failed, due to insert command to db failed");
        }
        return new FailureRecoveryResult(command.getId());
    }

    @Override
    public ExecuteType getExecuteType() {
        return FailureRecoveryExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

