/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause;

import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.pause.pause.PauseExecuteResult;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceExecutionEventListener;
import org.apache.dolphinscheduler.extract.master.transportor.WorkflowInstanceStateChangeEvent;

public class PauseExecuteFunction
implements ExecuteFunction<PauseExecuteRequest, PauseExecuteResult> {
    private final ProcessInstanceDao processInstanceDao;

    public PauseExecuteFunction(ProcessInstanceDao processInstanceDao) {
        this.processInstanceDao = processInstanceDao;
    }

    @Override
    public PauseExecuteResult execute(PauseExecuteRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().isRunning()) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, can not pause", workflowInstance.getName(), workflowInstance.getState()));
        }
        workflowInstance.setCommandType(CommandType.PAUSE);
        workflowInstance.addHistoryCmd(CommandType.PAUSE);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.READY_PAUSE, CommandType.PAUSE.getDescp() + " by " + request.getExecuteUser().getUserName());
        if (!this.processInstanceDao.updateById((Object)workflowInstance)) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s pause failed, due to update the workflow instance status in DB failed", workflowInstance.getName()));
        }
        try {
            ITaskInstanceExecutionEventListener iTaskInstanceExecutionEventListener = (ITaskInstanceExecutionEventListener)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)workflowInstance.getHost(), ITaskInstanceExecutionEventListener.class);
            iTaskInstanceExecutionEventListener.onWorkflowInstanceInstanceStateChange(new WorkflowInstanceStateChangeEvent(workflowInstance.getId().intValue(), 0, workflowInstance.getState(), workflowInstance.getId().intValue(), 0));
        }
        catch (Exception e) {
            throw new ExecuteRuntimeException(String.format("WorkflowInstance: %s pause failed", workflowInstance.getName()), e);
        }
        return new PauseExecuteResult(workflowInstance);
    }

    @Override
    public ExecuteType getExecuteType() {
        return PauseExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

