/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.rerun;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningResult;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.service.command.CommandService;

public class RepeatRunningExecuteFunction
implements ExecuteFunction<RepeatRunningRequest, RepeatRunningResult> {
    private final CommandService commandService;

    public RepeatRunningExecuteFunction(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public RepeatRunningResult execute(RepeatRunningRequest request) throws ExecuteRuntimeException {
        Preconditions.checkNotNull((Object)request, (Object)"request cannot be null");
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (workflowInstance.getState() == null || !workflowInstance.getState().isFinished()) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, cannot repeat running", workflowInstance.getName(), workflowInstance.getState()));
        }
        Command command = Command.builder().commandType(CommandType.REPEAT_RUNNING).commandParam(JSONUtils.toJsonString(this.createCommandParams(workflowInstance))).processDefinitionCode(workflowInstance.getProcessDefinitionCode().longValue()).processDefinitionVersion(workflowInstance.getProcessDefinitionVersion()).processInstanceId(workflowInstance.getId().intValue()).processInstancePriority(workflowInstance.getProcessInstancePriority()).testFlag(workflowInstance.getTestFlag()).build();
        if (this.commandService.createCommand(command) <= 0) {
            throw new ExecuteRuntimeException(String.format("Repeat running workflow instance: %s failed, due to insert command to db failed", workflowInstance.getName()));
        }
        return new RepeatRunningResult(command.getId());
    }

    @Override
    public ExecuteType getExecuteType() {
        return RepeatRunningExecuteFunctionBuilder.EXECUTE_TYPE;
    }

    private Map<String, Object> createCommandParams(ProcessInstance workflowInstance) {
        Map commandMap = (Map)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap<String, Object> repeatRunningCommandParams = new HashMap<String, Object>();
        Optional.ofNullable(MapUtils.getObject((Map)commandMap, (Object)"StartParams")).ifPresent(startParams -> repeatRunningCommandParams.put("StartParams", startParams));
        repeatRunningCommandParams.put("ProcessInstanceId", workflowInstance.getId());
        return repeatRunningCommandParams;
    }
}

