/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.rerun;

import java.util.concurrent.CompletableFuture;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteContext;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningExecuteFunction;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.rerun.RepeatRunningResult;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepeatRunningExecuteFunctionBuilder
implements ExecuteFunctionBuilder<RepeatRunningRequest, RepeatRunningResult> {
    public static final ExecuteType EXECUTE_TYPE = ExecuteType.REPEAT_RUNNING;
    @Autowired
    private CommandService commandService;

    @Override
    public CompletableFuture<ExecuteFunction<RepeatRunningRequest, RepeatRunningResult>> createWorkflowInstanceExecuteFunction(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new RepeatRunningExecuteFunction(this.commandService));
    }

    @Override
    public CompletableFuture<RepeatRunningRequest> createWorkflowInstanceExecuteRequest(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new RepeatRunningRequest(executeContext.getWorkflowInstance(), executeContext.getWorkflowDefinition(), executeContext.getExecuteUser()));
    }

    @Override
    public ExecuteType getExecuteType() {
        return EXECUTE_TYPE;
    }
}

