/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.stop;

import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteRuntimeException;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.stop.StopResult;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceExecutionEventListener;
import org.apache.dolphinscheduler.extract.master.transportor.WorkflowInstanceStateChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopExecuteFunction
implements ExecuteFunction<StopRequest, StopResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StopExecuteFunction.class);
    private final ProcessInstanceDao processInstanceDao;

    public StopExecuteFunction(ProcessInstanceDao processInstanceDao) {
        this.processInstanceDao = processInstanceDao;
    }

    @Override
    public StopResult execute(StopRequest request) throws ExecuteRuntimeException {
        ProcessInstance workflowInstance = request.getWorkflowInstance();
        if (!workflowInstance.getState().canStop() || workflowInstance.getState() == WorkflowExecutionStatus.READY_STOP) {
            throw new ExecuteRuntimeException(String.format("The workflow instance: %s status is %s, can not be stopped", workflowInstance.getName(), workflowInstance.getState()));
        }
        workflowInstance.setCommandType(CommandType.STOP);
        workflowInstance.addHistoryCmd(CommandType.STOP);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.READY_STOP, CommandType.STOP.getDescp() + " by user");
        if (this.processInstanceDao.updateById((Object)workflowInstance)) {
            log.info("Workflow instance {} ready to stop success, will call master to stop the workflow instance", (Object)workflowInstance.getName());
            try {
                ITaskInstanceExecutionEventListener iTaskInstanceExecutionEventListener = (ITaskInstanceExecutionEventListener)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)workflowInstance.getHost(), ITaskInstanceExecutionEventListener.class);
                iTaskInstanceExecutionEventListener.onWorkflowInstanceInstanceStateChange(new WorkflowInstanceStateChangeEvent(workflowInstance.getId().intValue(), 0, workflowInstance.getState(), workflowInstance.getId().intValue(), 0));
            }
            catch (Exception e) {
                throw new ExecuteRuntimeException(String.format("WorkflowInstance: %s stop failed", workflowInstance.getName()), e);
            }
            return new StopResult(workflowInstance);
        }
        throw new ExecuteRuntimeException("Workflow instance stop failed, due to update the workflow instance status failed");
    }

    @Override
    public ExecuteType getExecuteType() {
        return StopExecuteFunctionBuilder.EXECUTE_TYPE;
    }
}

