/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.ldap;

import lombok.NonNull;
import org.apache.dolphinscheduler.api.security.impl.AbstractAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.ldap.LdapService;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;

public class LdapAuthenticator
extends AbstractAuthenticator {
    @Autowired
    LdapService ldapService;

    @Override
    public User login(@NonNull String userId, String password) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        User user = null;
        String ldapEmail = this.ldapService.ldapLogin(userId, password);
        if (ldapEmail != null && (user = this.userService.getUserByUserName(userId)) == null && this.ldapService.createIfUserNotExists()) {
            user = this.userService.createUser(this.ldapService.getUserType(userId), userId, ldapEmail);
        }
        return user;
    }
}

