/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.ldap;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.security.LdapUserNotExistActionType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class LdapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapService.class);
    @Value(value="${security.authentication.ldap.user.admin:#{null}}")
    private String adminUserId;
    @Value(value="${security.authentication.ldap.urls:#{null}}")
    private String ldapUrls;
    @Value(value="${security.authentication.ldap.base-dn:#{null}}")
    private String ldapBaseDn;
    @Value(value="${security.authentication.ldap.username:#{null}}")
    private String ldapSecurityPrincipal;
    @Value(value="${security.authentication.ldap.password:#{null}}")
    private String ldapPrincipalPassword;
    @Value(value="${security.authentication.ldap.user.identity-attribute:#{null}}")
    private String ldapUserIdentifyingAttribute;
    @Value(value="${security.authentication.ldap.user.email-attribute:#{null}}")
    private String ldapEmailAttribute;
    @Value(value="${security.authentication.ldap.user.not-exist-action:CREATE}")
    private String ldapUserNotExistAction;
    @Value(value="${security.authentication.ldap.ssl.enable:false}")
    private Boolean sslEnable;
    @Value(value="${security.authentication.ldap.ssl.trust-store:#{null}}")
    private String trustStore;
    @Value(value="${security.authentication.ldap.ssl.trust-store-password:#{null}}")
    private String trustStorePassword;

    public UserType getUserType(String userId) {
        return this.adminUserId.equalsIgnoreCase(userId) ? UserType.ADMIN_USER : UserType.GENERAL_USER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ldapLogin(String userId, String userPwd) {
        block22: {
            Properties searchEnv = this.getManagerLdapEnv();
            InitialLdapContext ctx = null;
            try {
                ctx = new InitialLdapContext(searchEnv, null);
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{this.ldapEmailAttribute});
                sc.setSearchScope(2);
                EqualsFilter filter = new EqualsFilter(this.ldapUserIdentifyingAttribute, userId);
                NamingEnumeration<SearchResult> results = ctx.search(this.ldapBaseDn, filter.toString(), sc);
                if (!results.hasMore()) break block22;
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                while (attrs.hasMore()) {
                    searchEnv.put("java.naming.security.principal", result.getNameInNamespace());
                    searchEnv.put("java.naming.security.credentials", userPwd);
                    try {
                        new InitialDirContext(searchEnv);
                    }
                    catch (Exception e) {
                        log.warn("invalid ldap credentials or ldap search error", (Throwable)e);
                        String string = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            log.error("ldap context close error", (Throwable)e2);
                        }
                        return string;
                    }
                    Attribute attr = attrs.next();
                    if (!attr.getID().equals(this.ldapEmailAttribute)) continue;
                    String string = (String)attr.get();
                    return string;
                }
            }
            catch (NamingException e) {
                log.error("ldap search error", (Throwable)e);
                String string = null;
                return string;
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    log.error("ldap context close error", (Throwable)e);
                }
            }
        }
        return null;
    }

    Properties getManagerLdapEnv() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapPrincipalPassword);
        env.put("java.naming.provider.url", this.ldapUrls);
        if (this.sslEnable.booleanValue()) {
            env.put("java.naming.security.protocol", "ssl");
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            if (StringUtils.isNotEmpty((CharSequence)this.trustStorePassword)) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            }
        }
        return env;
    }

    public LdapUserNotExistActionType getLdapUserNotExistAction() {
        if (StringUtils.isBlank((CharSequence)this.ldapUserNotExistAction)) {
            log.info("security.authentication.ldap.user.not.exist.action configuration is empty, the default value 'CREATE'");
            return LdapUserNotExistActionType.CREATE;
        }
        return LdapUserNotExistActionType.valueOf(this.ldapUserNotExistAction);
    }

    public boolean createIfUserNotExists() {
        return this.getLdapUserNotExistAction() == LdapUserNotExistActionType.CREATE;
    }
}

