/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.RuleDefinition;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.DqRuleService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DqComparisonTypeMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleExecuteSqlMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleInputEntryMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleMapper;
import org.apache.dolphinscheduler.dao.utils.DqRuleUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.OptionSourceType;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.params.base.FormType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.PropsType;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.group.GroupParam;
import org.apache.dolphinscheduler.spi.params.group.GroupParamsProps;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.InputParamProps;
import org.apache.dolphinscheduler.spi.params.select.SelectParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DqRuleServiceImpl
extends BaseServiceImpl
implements DqRuleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DqRuleServiceImpl.class);
    @Autowired
    private DqRuleMapper dqRuleMapper;
    @Autowired
    private DqRuleInputEntryMapper dqRuleInputEntryMapper;
    @Autowired
    private DqRuleExecuteSqlMapper dqRuleExecuteSqlMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DqComparisonTypeMapper dqComparisonTypeMapper;

    @Override
    public String getRuleFormCreateJsonById(int id) {
        List ruleInputEntryList = this.dqRuleInputEntryMapper.getRuleInputEntryList(Integer.valueOf(id));
        if (ruleInputEntryList == null || ruleInputEntryList.isEmpty()) {
            throw new ServiceException(Status.QUERY_RULE_INPUT_ENTRY_LIST_ERROR);
        }
        return this.getRuleFormCreateJson(DqRuleUtils.transformInputEntry((List)ruleInputEntryList));
    }

    @Override
    public List<DqRule> queryAllRuleList() {
        return this.dqRuleMapper.selectList((Wrapper)new QueryWrapper());
    }

    @Override
    public List<ParamsOptions> getDatasourceOptionsById(int datasourceId) {
        List dataSourceList = this.dataSourceMapper.listAllDataSourceByType(Integer.valueOf(datasourceId));
        if (CollectionUtils.isEmpty((Collection)dataSourceList)) {
            return Collections.emptyList();
        }
        ArrayList<ParamsOptions> options = new ArrayList<ParamsOptions>();
        for (DataSource dataSource : dataSourceList) {
            ParamsOptions childrenOption = new ParamsOptions(dataSource.getName(), (Object)dataSource.getId(), false);
            options.add(childrenOption);
        }
        return options;
    }

    @Override
    public PageInfo<DqRule> queryRuleListPaging(User loginUser, String searchVal, Integer ruleType, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        IPage dqRulePage;
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startTime)) {
                start = DateUtils.stringToDate((String)startTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)endTime)) {
                end = DateUtils.stringToDate((String)endTime);
            }
        }
        catch (Exception e) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startTime,endTime");
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo<DqRule> pageInfo = new PageInfo<DqRule>(pageNo, pageSize);
        if (ruleType == null) {
            ruleType = -1;
        }
        if ((dqRulePage = this.dqRuleMapper.queryRuleListPaging((IPage)page, searchVal, ruleType.intValue(), start, end)) != null) {
            List dataList = dqRulePage.getRecords();
            dataList.forEach(dqRule -> {
                List ruleInputEntryList = DqRuleUtils.transformInputEntry((List)this.dqRuleInputEntryMapper.getRuleInputEntryList(dqRule.getId()));
                List ruleExecuteSqlList = this.dqRuleExecuteSqlMapper.getExecuteSqlList(dqRule.getId());
                RuleDefinition ruleDefinition = new RuleDefinition(ruleInputEntryList, ruleExecuteSqlList);
                dqRule.setRuleJson(JSONUtils.toJsonString((Object)ruleDefinition));
            });
            pageInfo.setTotal((int)dqRulePage.getTotal());
            pageInfo.setTotalList(dataList);
        }
        return pageInfo;
    }

    private String getRuleFormCreateJson(List<DqRuleInputEntry> ruleInputEntryList) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (DqRuleInputEntry inputEntry : ruleInputEntryList) {
            if (!Boolean.TRUE.equals(inputEntry.getIsShow())) continue;
            switch (Objects.requireNonNull(FormType.of((String)inputEntry.getType()))) {
                case INPUT: {
                    params.add(this.getInputParam(inputEntry));
                    break;
                }
                case SELECT: {
                    params.add(this.getSelectParam(inputEntry));
                    break;
                }
                case TEXTAREA: {
                    params.add(this.getTextareaParam(inputEntry));
                    break;
                }
                case GROUP: {
                    params.add(this.getGroupParam(inputEntry));
                    break;
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String result = null;
        try {
            result = mapper.writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            log.error("Json parse error.", (Throwable)e);
        }
        return result;
    }

    private InputParam getTextareaParam(DqRuleInputEntry inputEntry) {
        InputParamProps paramProps = new InputParamProps();
        paramProps.setDisabled(Boolean.valueOf(inputEntry.getCanEdit() == false));
        paramProps.setSize("small");
        paramProps.setType(PropsType.TEXTAREA.getPropsType());
        paramProps.setRows(Integer.valueOf(1));
        return InputParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getIsValidate().booleanValue()).build()).setProps(paramProps).setValue((Object)inputEntry.getData()).setPlaceholder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getIsEmit()) ? Collections.singletonList("change") : null).build();
    }

    private SelectParam getSelectParam(DqRuleInputEntry inputEntry) {
        List<ParamsOptions> options = null;
        switch (OptionSourceType.of((Integer)inputEntry.getOptionSourceType())) {
            case DEFAULT: {
                String optionStr = inputEntry.getOptions();
                if (!StringUtils.isNotEmpty((CharSequence)optionStr)) break;
                options = JSONUtils.toList((String)optionStr, ParamsOptions.class);
                break;
            }
            case DATASOURCE_TYPE: {
                options = new ArrayList();
                ParamsOptions paramsOptions = null;
                for (DbType dbtype : DbType.values()) {
                    paramsOptions = new ParamsOptions(dbtype.name(), (Object)dbtype.getCode(), false);
                    options.add(paramsOptions);
                }
                break;
            }
            case COMPARISON_TYPE: {
                options = new ArrayList();
                ParamsOptions comparisonOptions = null;
                List list = this.dqComparisonTypeMapper.selectList((Wrapper)new QueryWrapper().orderByAsc((Object)"id"));
                for (DqComparisonType type : list) {
                    comparisonOptions = new ParamsOptions(type.getType(), (Object)type.getId(), false);
                    options.add(comparisonOptions);
                }
                break;
            }
        }
        return SelectParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).setOptions(options).setValue((Object)inputEntry.getData()).setSize("small").setPlaceHolder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getIsEmit()) ? Collections.singletonList("change") : null).build();
    }

    private InputParam getInputParam(DqRuleInputEntry inputEntry) {
        InputParamProps paramProps = new InputParamProps();
        paramProps.setDisabled(Boolean.valueOf(inputEntry.getCanEdit() == false));
        paramProps.setSize("small");
        paramProps.setRows(Integer.valueOf(2));
        return InputParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getIsValidate().booleanValue()).build()).setProps(paramProps).setValue((Object)inputEntry.getData()).setPlaceholder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getIsEmit()) ? Collections.singletonList("change") : null).build();
    }

    private GroupParam getGroupParam(DqRuleInputEntry inputEntry) {
        return GroupParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getIsValidate().booleanValue()).build()).setProps(new GroupParamsProps().setRules(JSONUtils.toList((String)inputEntry.getOptions(), PluginParams.class)).setFontSize(20)).setEmit(Boolean.TRUE.equals(inputEntry.getIsEmit()) ? Collections.singletonList("change") : null).build();
    }
}

