/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.api.service.MetricsCleanUpService;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.IWorkflowInstanceService;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsCleanUpServiceImpl
implements MetricsCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsCleanUpServiceImpl.class);
    @Autowired
    private RegistryClient registryClient;

    @Override
    public void cleanUpWorkflowMetricsByDefinitionCode(Long workflowDefinitionCode) {
        List masterNodeList = this.registryClient.getServerList(RegistryNodeType.MASTER);
        for (Server server : masterNodeList) {
            this.cleanUpWorkflowMetrics(server, workflowDefinitionCode);
        }
    }

    private void cleanUpWorkflowMetrics(Server server, Long workflowDefinitionCode) {
        try {
            IWorkflowInstanceService iWorkflowInstanceService = (IWorkflowInstanceService)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)String.format("%s:%s", server.getHost(), server.getPort()), IWorkflowInstanceService.class);
            iWorkflowInstanceService.clearWorkflowMetrics(workflowDefinitionCode);
        }
        catch (Exception e) {
            log.error("Fail to clean up workflow related metrics on {} when deleting workflow definition {}, error message {}", new Object[]{server.getHost(), workflowDefinitionCode, e.getMessage()});
        }
    }

    @Override
    public void cleanUpApiResponseTimeMetricsByUserId(int userId) {
        ApiServerMetrics.cleanUpApiResponseTimeMetricsByUserId(userId);
    }
}

