/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationCreateRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationFilterRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationUpdateUpstreamRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessTaskRelationServiceImpl
extends BaseServiceImpl
implements ProcessTaskRelationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskRelationServiceImpl.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessDefinitionLogMapper processDefinitionLogMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;

    @Override
    @Transactional
    public Map<String, Object> createProcessTaskRelation(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Map<Long, ProcessTaskRelation> preTaskCodeMap;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            log.error("Process definition does not exist, processCode:{}.", (Object)processDefinitionCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        if (processDefinition.getProjectCode() != projectCode) {
            log.error("Process definition's project does not match project {}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_PROCESS_NOT_MATCH, new Object[0]);
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
        ArrayList processTaskRelations = Lists.newArrayList((Iterable)processTaskRelationList);
        if (!processTaskRelations.isEmpty() && !(preTaskCodeMap = processTaskRelations.stream().filter(r -> r.getPostTaskCode() == postTaskCode).collect(Collectors.toMap(ProcessTaskRelation::getPreTaskCode, processTaskRelation -> processTaskRelation))).isEmpty()) {
            if (preTaskCodeMap.containsKey(preTaskCode) || !preTaskCodeMap.containsKey(0L) && preTaskCode == 0L) {
                this.putMsg(result, Status.PROCESS_TASK_RELATION_EXIST, String.valueOf(processDefinitionCode));
                return result;
            }
            if (preTaskCodeMap.containsKey(0L) && preTaskCode != 0L) {
                processTaskRelations.remove(preTaskCodeMap.get(0L));
            }
        }
        TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(postTaskCode);
        ProcessTaskRelation processTaskRelation2 = this.setRelation(processDefinition, postTaskDefinition);
        if (preTaskCode != 0L) {
            TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(preTaskCode);
            List upstreamTaskRelationList = processTaskRelations.stream().filter(r -> r.getPostTaskCode() == preTaskCode).collect(Collectors.toList());
            if (upstreamTaskRelationList.isEmpty()) {
                ProcessTaskRelation preProcessTaskRelation = this.setRelation(processDefinition, preTaskDefinition);
                preProcessTaskRelation.setPreTaskCode(0L);
                preProcessTaskRelation.setPreTaskVersion(0);
                processTaskRelations.add(preProcessTaskRelation);
            }
            processTaskRelation2.setPreTaskCode(preTaskDefinition.getCode());
            processTaskRelation2.setPreTaskVersion(preTaskDefinition.getVersion());
        } else {
            processTaskRelation2.setPreTaskCode(0L);
            processTaskRelation2.setPreTaskVersion(0);
        }
        processTaskRelations.add(processTaskRelation2);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelations);
        return result;
    }

    private ProcessTaskRelationLog persist2ProcessTaskRelationLog(User user, ProcessTaskRelation processTaskRelation) {
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
        processTaskRelationLog.setOperator(user.getId().intValue());
        processTaskRelationLog.setOperateTime(new Date());
        int result = this.processTaskRelationLogMapper.insert((Object)processTaskRelationLog);
        if (result <= 0) {
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_LOG_ERROR, processTaskRelationLog.getPreTaskCode(), processTaskRelationLog.getPostTaskCode());
        }
        return processTaskRelationLog;
    }

    private List<ProcessTaskRelationLog> batchPersist2ProcessTaskRelationLog(User user, List<ProcessTaskRelation> processTaskRelations) {
        Date now = new Date();
        ArrayList<ProcessTaskRelationLog> processTaskRelationLogs = new ArrayList<ProcessTaskRelationLog>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
            processTaskRelationLog.setOperator(user.getId().intValue());
            processTaskRelationLog.setOperateTime(now);
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        int result = this.processTaskRelationLogMapper.batchInsert(processTaskRelationLogs);
        if (result != processTaskRelationLogs.size()) {
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_LOG_ERROR);
        }
        return processTaskRelationLogs;
    }

    private void updateVersions(ProcessTaskRelation processTaskRelation) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processTaskRelation.getProcessDefinitionCode());
        processTaskRelation.setProcessDefinitionVersion(processDefinition.getVersion());
        TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(processTaskRelation.getPreTaskCode());
        processTaskRelation.setPreTaskVersion(preTaskDefinition.getVersion());
        TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(processTaskRelation.getPostTaskCode());
        processTaskRelation.setPostTaskVersion(postTaskDefinition.getVersion());
    }

    @Override
    @Transactional
    public ProcessTaskRelation createProcessTaskRelationV2(User loginUser, TaskRelationCreateRequest taskRelationCreateRequest) {
        ProcessTaskRelation processTaskRelation = taskRelationCreateRequest.convert2ProcessTaskRelation();
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processTaskRelation.getProcessDefinitionCode());
        if (processDefinition == null) {
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processTaskRelation.getProcessDefinitionCode()));
        }
        if (processTaskRelation.getProjectCode() == 0L) {
            processTaskRelation.setProjectCode(processDefinition.getProjectCode());
        }
        Project project = this.projectMapper.queryByCode(processTaskRelation.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        this.updateVersions(processTaskRelation);
        int insert = this.processTaskRelationMapper.insert((Object)processTaskRelation);
        if (insert <= 0) {
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR, processTaskRelation.getPreTaskCode(), processTaskRelation.getPostTaskCode());
        }
        this.persist2ProcessTaskRelationLog(loginUser, processTaskRelation);
        return processTaskRelation;
    }

    private ProcessTaskRelation setRelation(ProcessDefinition processDefinition, TaskDefinition taskDefinition) {
        Date now = new Date();
        ProcessTaskRelation processTaskRelation = new ProcessTaskRelation();
        processTaskRelation.setProjectCode(processDefinition.getProjectCode());
        processTaskRelation.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelation.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelation.setPostTaskCode(taskDefinition.getCode());
        processTaskRelation.setPostTaskVersion(taskDefinition.getVersion());
        processTaskRelation.setConditionType(ConditionType.NONE);
        processTaskRelation.setConditionParams("{}");
        processTaskRelation.setCreateTime(now);
        processTaskRelation.setUpdateTime(now);
        return processTaskRelation;
    }

    private void updateProcessDefiniteVersion(User loginUser, Map<String, Object> result, ProcessDefinition processDefinition) {
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            log.error("Update process definition error, projectCode:{}, processDefinitionCode:{}.", (Object)processDefinition.getProjectCode(), (Object)processDefinition.getCode());
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Update process definition complete, new version is {}, projectCode:{}, processDefinitionCode:{}.", new Object[]{insertVersion, processDefinition.getProjectCode(), processDefinition.getCode()});
        processDefinition.setVersion(insertVersion);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteTaskProcessRelation(User loginUser, long projectCode, long processDefinitionCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            log.error("Delete task process relation error due to parameter taskCode is 0, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
            this.putMsg(result, Status.DELETE_TASK_PROCESS_RELATION_ERROR, new Object[0]);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)processDefinitionCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (null == taskDefinition) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        if (CollectionUtils.isEmpty((Collection)processTaskRelationList)) {
            log.error("Process task relations are empty, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
            this.putMsg(result, Status.DATA_IS_NULL, "processTaskRelationList");
            return result;
        }
        ArrayList downstreamList = Lists.newArrayList();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPreTaskCode() == taskCode) {
                downstreamList.add(processTaskRelation.getPostTaskCode());
            }
            if (processTaskRelation.getPostTaskCode() != taskCode) continue;
            processTaskRelationList.remove(processTaskRelation);
        }
        if (CollectionUtils.isNotEmpty((Collection)downstreamList)) {
            String downstream = StringUtils.join((Iterable)downstreamList, (String)",");
            log.warn("Relation can not be deleted because task has downstream tasks:[{}], projectCode:{}, processDefinitionCode:{}, taskDefinitionCode:{}.", new Object[]{downstream, projectCode, processDefinitionCode, taskCode});
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, downstream);
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        if ("CONDITIONS".equals(taskDefinition.getTaskType()) || "DEPENDENT".equals(taskDefinition.getTaskType()) || "SUB_PROCESS".equals(taskDefinition.getTaskType())) {
            int deleteTaskDefinition = this.taskDefinitionMapper.deleteByCode(taskCode);
            if (0 == deleteTaskDefinition) {
                log.error("Delete task definition error, taskDefinitionCode:{}.", (Object)taskCode);
                this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
                throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
            }
            log.info("Delete {} type task definition complete, taskDefinitionCode:{}.", (Object)taskDefinition.getTaskType(), (Object)taskCode);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void deleteTaskProcessRelationV2(User loginUser, long preTaskCode, long postTaskCode) {
        ProcessTaskRelation processTaskRelation = new TaskRelationFilterRequest(preTaskCode, postTaskCode).convert2TaskDefinition();
        Page page = new Page((long)new TaskRelationFilterRequest(preTaskCode, postTaskCode).getPageNo().intValue(), (long)new TaskRelationFilterRequest(preTaskCode, postTaskCode).getPageSize().intValue());
        IPage processTaskRelationIPage = this.processTaskRelationMapper.filterProcessTaskRelation((IPage)page, processTaskRelation);
        List processTaskRelations = processTaskRelationIPage.getRecords();
        if (processTaskRelations.size() != 1) {
            throw new ServiceException(Status.PROCESS_TASK_RELATION_NOT_EXPECT, 1, processTaskRelations.size());
        }
        ProcessTaskRelation processTaskRelationDb = (ProcessTaskRelation)processTaskRelations.get(0);
        Project project = this.projectMapper.queryByCode(processTaskRelationDb.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, null);
        this.processTaskRelationMapper.deleteById((Serializable)processTaskRelationDb.getId());
    }

    @Override
    @Transactional
    public List<ProcessTaskRelation> updateUpstreamTaskDefinitionWithSyncDag(User loginUser, long taskCode, Boolean needSyncDag, TaskRelationUpdateUpstreamRequest taskRelationUpdateUpstreamRequest) {
        int delete;
        TaskDefinition downstreamTask = this.taskDefinitionMapper.queryByCode(taskCode);
        if (downstreamTask == null) {
            throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCode);
        }
        List<Long> upstreamTaskCodes = taskRelationUpdateUpstreamRequest.getUpstreams();
        ProcessTaskRelation processTaskRelation = new ProcessTaskRelation();
        processTaskRelation.setPostTaskCode(taskCode);
        Page page = new Page((long)taskRelationUpdateUpstreamRequest.getPageNo().intValue(), (long)taskRelationUpdateUpstreamRequest.getPageSize().intValue());
        IPage processTaskRelationExistsIPage = this.processTaskRelationMapper.filterProcessTaskRelation((IPage)page, processTaskRelation);
        List processTaskRelationExists = processTaskRelationExistsIPage.getRecords();
        ProcessDefinition processDefinition = null;
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationExists)) {
            processDefinition = this.processDefinitionMapper.queryByCode(((ProcessTaskRelation)processTaskRelationExists.get(0)).getProcessDefinitionCode());
        } else if (taskRelationUpdateUpstreamRequest.getWorkflowCode() != 0L) {
            processDefinition = this.processDefinitionMapper.queryByCode(taskRelationUpdateUpstreamRequest.getWorkflowCode());
        }
        if (processDefinition == null) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, taskRelationUpdateUpstreamRequest.toString());
        }
        processDefinition.setUpdateTime(new Date());
        int insertVersion = processDefinition.getVersion();
        if (needSyncDag.booleanValue() && (insertVersion = this.saveProcessDefine(loginUser, processDefinition)) <= 0) {
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        List taskCodeCreates = upstreamTaskCodes.stream().filter(upstreamTaskCode -> processTaskRelationExists.stream().noneMatch(processTaskRelationExist -> processTaskRelationExist.getPreTaskCode() == upstreamTaskCode.longValue())).collect(Collectors.toList());
        List taskCodeDeletes = processTaskRelationExists.stream().filter(ptr -> !upstreamTaskCodes.contains(ptr.getPreTaskCode())).map(ProcessTaskRelation::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taskCodeDeletes) && (delete = this.processTaskRelationMapper.deleteBatchIds(taskCodeDeletes)) != taskCodeDeletes.size()) {
            throw new ServiceException(Status.PROCESS_TASK_RELATION_BATCH_DELETE_ERROR, taskCodeDeletes);
        }
        ArrayList<ProcessTaskRelation> processTaskRelations = new ArrayList<ProcessTaskRelation>();
        Iterator iterator = taskCodeCreates.iterator();
        while (iterator.hasNext()) {
            long createCode = (Long)iterator.next();
            long upstreamCode = 0L;
            int version = 0;
            if (createCode != 0L) {
                TaskDefinition upstreamTask = this.taskDefinitionMapper.queryByCode(createCode);
                if (upstreamTask == null) {
                    throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, createCode);
                }
                upstreamCode = upstreamTask.getCode();
                version = upstreamTask.getVersion();
            }
            ProcessTaskRelation processTaskRelationCreate = new ProcessTaskRelation(null, processDefinition.getVersion(), downstreamTask.getProjectCode(), processDefinition.getCode(), upstreamCode, version, downstreamTask.getCode(), downstreamTask.getVersion(), null, null);
            processTaskRelations.add(processTaskRelationCreate);
        }
        int batchInsert = this.processTaskRelationMapper.batchInsert(processTaskRelations);
        if (batchInsert != processTaskRelations.size()) {
            throw new ServiceException(Status.PROCESS_TASK_RELATION_BATCH_CREATE_ERROR, taskCodeCreates);
        }
        int saveTaskRelationResult = this.saveTaskRelation(loginUser, processDefinition, insertVersion);
        if (saveTaskRelationResult != 0) {
            log.error("Save process task relations error, projectCode:{}, processCode:{}, processVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion});
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        log.info("Save process task relations complete, projectCode:{}, processCode:{}, processVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion});
        ((ProcessTaskRelation)processTaskRelations.get(0)).setProcessDefinitionVersion(insertVersion);
        return processTaskRelations;
    }

    public int saveTaskRelation(User loginUser, ProcessDefinition processDefinition, int processDefinitionVersion) {
        int resultLog;
        List processTaskRelations;
        int insert;
        long projectCode = processDefinition.getProjectCode();
        long processDefinitionCode = processDefinition.getCode();
        List taskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
        List taskRelationList = taskRelations.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        List taskCodeList = taskRelations.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toList());
        List taskDefinitions = this.taskDefinitionMapper.queryByCodeList(taskCodeList);
        List taskDefinitionLogs = taskDefinitions.stream().map(TaskDefinitionLog::new).collect(Collectors.toList());
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (ProcessTaskRelationLog processTaskRelationLog : taskRelationList) {
            processTaskRelationLog.setProjectCode(projectCode);
            processTaskRelationLog.setProcessDefinitionCode(processDefinitionCode);
            processTaskRelationLog.setProcessDefinitionVersion(processDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    processTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(processTaskRelationLog.getPostTaskCode())) != null) {
                    processTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            processTaskRelationLog.setCreateTime(now);
            processTaskRelationLog.setUpdateTime(now);
            processTaskRelationLog.setOperator(loginUser.getId().intValue());
            processTaskRelationLog.setOperateTime(now);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskRelations)) {
            Set taskRelationSet;
            Set processTaskRelationSet = taskRelations.stream().map(ProcessTaskRelation::hashCode).collect(Collectors.toSet());
            boolean isSame = org.apache.commons.collections.CollectionUtils.isEqualCollection(processTaskRelationSet, taskRelationSet = taskRelationList.stream().map(ProcessTaskRelationLog::hashCode).collect(Collectors.toSet()));
            if (isSame) {
                return 0;
            }
            this.processTaskRelationMapper.deleteByCode(projectCode, processDefinitionCode);
        }
        return ((insert = this.processTaskRelationMapper.batchInsert(processTaskRelations = taskRelationList.stream().map(ProcessTaskRelation::new).collect(Collectors.toList()))) & (resultLog = this.processTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    public int saveProcessDefine(User loginUser, ProcessDefinition processDefinition) {
        ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition);
        Integer version = this.processDefinitionLogMapper.queryMaxVersionForDefinition(processDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        processDefinitionLog.setVersion(insertVersion);
        processDefinitionLog.setOperator(loginUser.getId().intValue());
        processDefinitionLog.setOperateTime(processDefinition.getUpdateTime());
        processDefinitionLog.setId(null);
        int insertLog = this.processDefinitionLogMapper.insert((Object)processDefinitionLog);
        processDefinitionLog.setId(processDefinition.getId());
        int result = this.processDefinitionMapper.updateById((ProcessDefinition)processDefinitionLog);
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    private void updateRelation(User loginUser, Map<String, Object> result, ProcessDefinition processDefinition, List<ProcessTaskRelation> processTaskRelationList) {
        List relationLogs = processTaskRelationList.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), processDefinition.getVersion(), relationLogs, (List)Lists.newArrayList(), Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Update task relations error, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinition.getCode(), processDefinition.getVersion()});
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Update task relations complete, projectCode:{}, processDefinitionCode:{}, processDefinitionVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinition.getCode(), processDefinition.getVersion()});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteUpstreamRelation(User loginUser, long projectCode, String preTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)preTaskCodes)) {
            log.warn("Parameter preTaskCodes is empty.");
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List upstreamList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)upstreamList)) {
            log.error("Upstream tasks based on the task do not exist, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List preTaskCodeList = Lists.newArrayList((Object[])preTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (preTaskCodeList.contains(0L)) {
            log.warn("Parameter preTaskCodes contain 0.");
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List currentUpstreamList = upstreamList.stream().map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toList());
        if (currentUpstreamList.contains(0L)) {
            log.error("Upstream taskCodes based on the task contain, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "currentUpstreamList");
            return result;
        }
        ArrayList tmpCurrent = Lists.newArrayList(currentUpstreamList);
        tmpCurrent.removeAll(preTaskCodeList);
        preTaskCodeList.removeAll(currentUpstreamList);
        if (!preTaskCodeList.isEmpty()) {
            String invalidPreTaskCodes = StringUtils.join(preTaskCodeList, (String)",");
            log.error("Some upstream taskCodes are invalid, preTaskCodeList:{}.", (Object)invalidPreTaskCodes);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, invalidPreTaskCodes);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(((ProcessTaskRelation)upstreamList.get(0)).getProcessDefinitionCode());
        if (processDefinition == null) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)((ProcessTaskRelation)upstreamList.get(0)).getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(((ProcessTaskRelation)upstreamList.get(0)).getProcessDefinitionCode()));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getCode());
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        ArrayList processTaskRelationWaitRemove = Lists.newArrayList();
        for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
            if (currentUpstreamList.size() > 1) {
                if (!currentUpstreamList.contains(processTaskRelation.getPreTaskCode())) continue;
                currentUpstreamList.remove(processTaskRelation.getPreTaskCode());
                processTaskRelationWaitRemove.add(processTaskRelation);
                continue;
            }
            if (processTaskRelation.getPostTaskCode() != taskCode || !currentUpstreamList.isEmpty() && !tmpCurrent.isEmpty()) continue;
            processTaskRelation.setPreTaskVersion(0);
            processTaskRelation.setPreTaskCode(0L);
        }
        processTaskRelationList.removeAll(processTaskRelationWaitRemove);
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteDownstreamRelation(User loginUser, long projectCode, String postTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)postTaskCodes)) {
            log.warn("Parameter postTaskCodes is empty.");
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        List downstreamList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)downstreamList)) {
            log.error("Downstream tasks based on the task do not exist, theTaskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List postTaskCodeList = Lists.newArrayList((Object[])postTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (postTaskCodeList.contains(0L)) {
            log.warn("Parameter postTaskCodes contains 0.");
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(((ProcessTaskRelation)downstreamList.get(0)).getProcessDefinitionCode());
        if (processDefinition == null) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)((ProcessTaskRelation)downstreamList.get(0)).getProcessDefinitionCode());
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(((ProcessTaskRelation)downstreamList.get(0)).getProcessDefinitionCode()));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getCode());
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        processTaskRelationList.removeIf(processTaskRelation -> postTaskCodeList.contains(processTaskRelation.getPostTaskCode()) && processTaskRelation.getPreTaskCode() == taskCode);
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    @Override
    public Map<String, Object> queryUpstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPreTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPreTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryDownstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPostTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPostTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteEdge(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            log.error("Process definition does not exist, projectCode\uff1a{}\uff0c processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        if (CollectionUtils.isEmpty((Collection)processTaskRelationList)) {
            log.error("Process task relations are empty, projectCode:{}, processDefinitionCode:{}.", (Object)projectCode, (Object)processDefinitionCode);
            this.putMsg(result, Status.DATA_IS_NULL, "processTaskRelationList");
            return result;
        }
        HashMap<Long, List> taskRelationMap = new HashMap<Long, List>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
            taskRelationMap.compute(processTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<ProcessTaskRelation>();
                }
                v.add(processTaskRelation);
                return v;
            });
        }
        if (!taskRelationMap.containsKey(postTaskCode)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCode");
            return result;
        }
        if (((List)taskRelationMap.get(postTaskCode)).size() > 1) {
            for (ProcessTaskRelation processTaskRelation : (List)taskRelationMap.get(postTaskCode)) {
                if (processTaskRelation.getPreTaskCode() != preTaskCode) continue;
                int delete = this.processTaskRelationMapper.deleteById((Serializable)processTaskRelation.getId());
                if (delete == 0) {
                    log.error("Delete task relation edge error, processTaskRelationId:{}, preTaskCode:{}, postTaskCode:{}", new Object[]{processTaskRelation.getId(), preTaskCode, postTaskCode});
                    this.putMsg(result, Status.DELETE_EDGE_ERROR, new Object[0]);
                    throw new ServiceException(Status.DELETE_EDGE_ERROR);
                }
                log.info("Delete task relation edge complete, processTaskRelationId:{}, preTaskCode:{}, postTaskCode:{}", new Object[]{processTaskRelation.getId(), preTaskCode, postTaskCode});
                processTaskRelationList.remove(processTaskRelation);
            }
        } else {
            ProcessTaskRelation processTaskRelation = (ProcessTaskRelation)((List)taskRelationMap.get(postTaskCode)).get(0);
            processTaskRelationList.remove(processTaskRelation);
            processTaskRelation.setPreTaskVersion(0);
            processTaskRelation.setPreTaskCode(0L);
            processTaskRelationList.add(processTaskRelation);
            log.info("Delete task relation through set invalid value for it: preTaskCode from {} to 0, processTaskRelationId:{}.", (Object)preTaskCode, (Object)processTaskRelation.getId());
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    @Override
    public List<ProcessTaskRelation> queryByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        return this.processTaskRelationMapper.queryProcessTaskRelationsByProcessDefinitionCode(workflowDefinitionCode, Integer.valueOf(workflowDefinitionVersion));
    }

    @Override
    public void deleteByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        this.processTaskRelationMapper.deleteByWorkflowDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
    }

    private TaskDefinition buildTaskDefinition() {
        return new TaskDefinition(){

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TaskDefinition)) {
                    return false;
                }
                TaskDefinition that = (TaskDefinition)o;
                return this.getCode() == that.getCode() && this.getVersion() == that.getVersion() && this.getProjectCode() == that.getProjectCode();
            }

            public int hashCode() {
                return Objects.hash(this.getCode(), this.getVersion(), this.getProjectCode());
            }
        };
    }
}

