/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectParameterService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectParameter;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectParameterMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectParameterServiceImpl
extends BaseServiceImpl
implements ProjectParameterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectParameterServiceImpl.class);
    @Autowired
    private ProjectParameterMapper projectParameterMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProjectMapper projectMapper;

    @Override
    @Transactional
    public Result createProjectParameter(User loginUser, long projectCode, String projectParameterName, String projectParameterValue) {
        Result<ProjectParameter> result = new Result<ProjectParameter>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProjectParameter projectParameter = (ProjectParameter)this.projectParameterMapper.selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ProjectParameter::getProjectCode, (Object)projectCode)).eq(ProjectParameter::getParamName, (Object)projectParameterName));
        if (projectParameter != null) {
            log.warn("ProjectParameter {} already exists.", (Object)projectParameter.getParamName());
            this.putMsg(result, Status.PROJECT_PARAMETER_ALREADY_EXISTS, new Object[]{projectParameter.getParamName()});
            return result;
        }
        Date now = new Date();
        try {
            projectParameter = ProjectParameter.builder().paramName(projectParameterName).paramValue(projectParameterValue).code(CodeGenerateUtils.getInstance().genCode()).projectCode(projectCode).userId(loginUser.getId()).createTime(now).updateTime(now).build();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate project parameter code error.", (Throwable)e);
            this.putMsg(result, Status.CREATE_PROJECT_PARAMETER_ERROR, new Object[0]);
            return result;
        }
        if (this.projectParameterMapper.insert((Object)projectParameter) > 0) {
            log.info("Project parameter is created and id is :{}", (Object)projectParameter.getId());
            result.setData(projectParameter);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Project parameter create error, projectName:{}.", (Object)projectParameter.getParamName());
            this.putMsg(result, Status.CREATE_PROJECT_PARAMETER_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result updateProjectParameter(User loginUser, long projectCode, long code, String projectParameterName, String projectParameterValue) {
        Result<ProjectParameter> result = new Result<ProjectParameter>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProjectParameter projectParameter = this.projectParameterMapper.queryByCode(code);
        if (projectParameter == null || projectCode != projectParameter.getProjectCode()) {
            log.error("Project parameter does not exist, code:{}.", (Object)code);
            this.putMsg(result, Status.PROJECT_PARAMETER_NOT_EXISTS, new Object[]{String.valueOf(code)});
            return result;
        }
        ProjectParameter tempProjectParameter = (ProjectParameter)this.projectParameterMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ProjectParameter::getProjectCode, (Object)projectCode)).eq(ProjectParameter::getParamName, (Object)projectParameterName)).ne(ProjectParameter::getCode, (Object)code));
        if (tempProjectParameter != null) {
            log.error("Project parameter name {} already exists", (Object)projectParameterName);
            this.putMsg(result, Status.PROJECT_PARAMETER_ALREADY_EXISTS, new Object[]{projectParameterName});
            return result;
        }
        projectParameter.setParamName(projectParameterName);
        projectParameter.setParamValue(projectParameterValue);
        if (this.projectParameterMapper.updateById((Object)projectParameter) > 0) {
            log.info("Project parameter is updated and id is :{}", (Object)projectParameter.getId());
            result.setData(projectParameter);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Project parameter update error, {}.", (Object)projectParameterName);
            this.putMsg(result, Status.UPDATE_PROJECT_PARAMETER_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result deleteProjectParametersByCode(User loginUser, long projectCode, long code) {
        Result<Boolean> result = new Result<Boolean>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProjectParameter projectParameter = this.projectParameterMapper.queryByCode(code);
        if (projectParameter == null || projectCode != projectParameter.getProjectCode()) {
            log.error("Project parameter does not exist, code:{}.", (Object)code);
            this.putMsg(result, Status.PROJECT_PARAMETER_NOT_EXISTS, new Object[]{String.valueOf(code)});
            return result;
        }
        if (this.projectParameterMapper.deleteById((Serializable)projectParameter.getId()) > 0) {
            log.info("Project parameter is deleted and id is :{}.", (Object)projectParameter.getId());
            result.setData(Boolean.TRUE);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Project parameter delete error, {}.", (Object)projectParameter.getParamName());
            this.putMsg(result, Status.DELETE_PROJECT_PARAMETER_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result batchDeleteProjectParametersByCodes(User loginUser, long projectCode, String codes) {
        Result result = new Result();
        if (StringUtils.isEmpty((CharSequence)codes)) {
            log.error("Project parameter codes is empty, projectCode is {}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_PARAMETER_CODE_EMPTY, new Object[0]);
            return result;
        }
        Set requestCodeSet = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List projectParameterList = this.projectParameterMapper.queryByCodes(requestCodeSet);
        Set actualCodeSet = projectParameterList.stream().map(ProjectParameter::getCode).collect(Collectors.toSet());
        Set diffCode = requestCodeSet.stream().filter(code -> !actualCodeSet.contains(code)).collect(Collectors.toSet());
        String diffCodeString = diffCode.stream().map(String::valueOf).collect(Collectors.joining(","));
        if (CollectionUtils.isNotEmpty(diffCode)) {
            log.error("Project parameter does not exist, codes:{}.", (Object)diffCodeString);
            throw new ServiceException(Status.PROJECT_PARAMETER_NOT_EXISTS, diffCodeString);
        }
        for (ProjectParameter projectParameter : projectParameterList) {
            try {
                this.deleteProjectParametersByCode(loginUser, projectCode, projectParameter.getCode());
            }
            catch (Exception e) {
                throw new ServiceException(Status.DELETE_PROJECT_PARAMETER_ERROR, e.getMessage());
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProjectParameterListPaging(User loginUser, long projectCode, Integer pageSize, Integer pageNo, String searchVal) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage iPage = this.projectParameterMapper.queryProjectParameterListPaging((IPage)page, projectCode, null, searchVal);
        List projectParameterList = iPage.getRecords();
        pageInfo.setTotal((int)iPage.getTotal());
        pageInfo.setTotalList(projectParameterList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProjectParameterByCode(User loginUser, long projectCode, long code) {
        Result<ProjectParameter> result = new Result<ProjectParameter>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        ProjectParameter projectParameter = this.projectParameterMapper.queryByCode(code);
        if (projectParameter == null || projectCode != projectParameter.getProjectCode()) {
            log.error("Project parameter does not exist, code:{}.", (Object)code);
            this.putMsg(result, Status.PROJECT_PARAMETER_NOT_EXISTS, new Object[]{String.valueOf(code)});
            return result;
        }
        result.setData(projectParameter);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

