/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.service.TaskDefinitionLogService;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.repository.ProcessTaskRelationLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDefinitionLogServiceImpl
implements TaskDefinitionLogService {
    @Autowired
    private ProcessTaskRelationLogDao processTaskRelationLogDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;

    @Override
    public void deleteTaskByWorkflowDefinitionCode(long workflowDefinitionCode) {
        List processTaskRelations = this.processTaskRelationLogDao.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        if (CollectionUtils.isEmpty((Collection)processTaskRelations)) {
            return;
        }
        HashSet<Long> needToDeleteTaskDefinitionCodes = new HashSet<Long>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            needToDeleteTaskDefinitionCodes.add(processTaskRelation.getPreTaskCode());
            needToDeleteTaskDefinitionCodes.add(processTaskRelation.getPostTaskCode());
        }
        this.taskDefinitionLogDao.deleteByTaskDefinitionCodes(needToDeleteTaskDefinitionCodes);
        this.processTaskRelationLogDao.deleteByWorkflowDefinitionCode(workflowDefinitionCode);
    }
}

