/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.api.dto.taskInstance.TaskInstanceRemoveCacheResponse;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.DqExecuteResultDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.TaskCacheUtils;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.worker.IStreamingTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.ITaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillResponse;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceTriggerSavepointResponse;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInstanceServiceImpl
extends BaseServiceImpl
implements TaskInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    TaskInstanceDao taskInstanceDao;
    @Autowired
    UsersService usersService;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private DqExecuteResultDao dqExecuteResultDao;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;

    @Override
    public Result queryTaskListPaging(User loginUser, long projectCode, Integer processInstanceId, String processInstanceName, String processDefinitionName, String taskName, Long taskCode, String executorName, String startDate, String endDate, String searchVal, TaskExecutionStatus stateType, String host, TaskExecuteType taskExecuteType, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:task-instance:view");
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.getCode()};
        }
        Date start = this.checkAndParseDateParameters(startDate);
        Date end = this.checkAndParseDateParameters(endDate);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage taskInstanceIPage = taskExecuteType == TaskExecuteType.STREAM ? this.taskInstanceMapper.queryStreamTaskInstanceListPaging((IPage)page, Long.valueOf(projectCode), processDefinitionName, searchVal, taskName, taskCode, executorName, statusArray, host, taskExecuteType, start, end) : this.taskInstanceMapper.queryTaskInstanceListPaging((IPage)page, Long.valueOf(projectCode), processInstanceId, processInstanceName, searchVal, taskName, taskCode, executorName, statusArray, host, taskExecuteType, start, end);
        HashSet<String> exclusionSet = new HashSet<String>();
        exclusionSet.add("class");
        exclusionSet.add("taskJson");
        List taskInstanceList = taskInstanceIPage.getRecords();
        List<Integer> executorIds = taskInstanceList.stream().map(TaskInstance::getExecutorId).distinct().collect(Collectors.toList());
        List<User> users = this.usersService.queryUser(executorIds);
        Map<Integer, User> userMap = users.stream().collect(Collectors.toMap(User::getId, v -> v));
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstance.setDuration(DateUtils.format2Duration((Date)taskInstance.getStartTime(), (Date)taskInstance.getEndTime()));
            User user = userMap.get(taskInstance.getExecutorId());
            if (user == null) continue;
            taskInstance.setExecutorName(user.getUserName());
        }
        pageInfo.setTotal((int)taskInstanceIPage.getTotal());
        pageInfo.setTotalList(CollectionUtils.getListByExclusion((List)taskInstanceIPage.getRecords(), exclusionSet));
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Result forceTaskSuccess(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-instance:force-success");
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        TaskInstance task = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (task == null) {
            log.error("Task instance can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition can not be found, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)task.getTaskCode());
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[]{taskInstanceId});
            return result;
        }
        if (!task.getState().isFailure() && !task.getState().isKill()) {
            log.warn("{} type task instance can not perform force success, projectCode:{}, taskInstanceId:{}.", new Object[]{task.getState().getDesc(), projectCode, taskInstanceId});
            this.putMsg(result, Status.TASK_INSTANCE_STATE_OPERATION_ERROR, new Object[]{taskInstanceId, task.getState().toString()});
            return result;
        }
        task.setState(TaskExecutionStatus.FORCED_SUCCESS);
        task.setEndTime(new Date());
        int changedNum = this.taskInstanceMapper.updateById((Object)task);
        if (changedNum > 0) {
            this.processService.forceProcessInstanceSuccessByTaskInstanceId(taskInstanceId);
            log.info("Task instance performs force success complete, projectCode:{}, taskInstanceId:{}", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Task instance performs force success complete, projectCode:{}, taskInstanceId:{}", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.FORCE_TASK_SUCCESS_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result taskSavePoint(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-instance:force-success");
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task definition can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        IStreamingTaskInstanceOperator streamingTaskInstanceOperator = (IStreamingTaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), IStreamingTaskInstanceOperator.class);
        TaskInstanceTriggerSavepointResponse taskInstanceTriggerSavepointResponse = streamingTaskInstanceOperator.triggerSavepoint(new TaskInstanceTriggerSavepointRequest(taskInstanceId.intValue()));
        log.info("StreamingTaskInstance trigger savepoint response: {}", (Object)taskInstanceTriggerSavepointResponse);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result stopTask(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-instance:force-success");
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task definition can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        ITaskInstanceOperator iTaskInstanceOperator = (ITaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ITaskInstanceOperator.class);
        TaskInstanceKillResponse taskInstanceKillResponse = iTaskInstanceOperator.killTask(new TaskInstanceKillRequest(taskInstanceId));
        log.info("TaskInstance kill response: {}", (Object)taskInstanceKillResponse);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public TaskInstance queryTaskInstanceById(User loginUser, long projectCode, Long taskInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:task-instance:force-success");
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task instance can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
        }
        return taskInstance;
    }

    @Override
    public TaskInstanceRemoveCacheResponse removeTaskInstanceCache(User loginUser, long projectCode, Integer taskInstanceId) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:process-instance:update");
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (taskInstance == null) {
            log.error("Task definition can not be found, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstanceId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return new TaskInstanceRemoveCacheResponse(result);
        }
        String tagCacheKey = taskInstance.getCacheKey();
        Pair taskIdAndCacheKey = TaskCacheUtils.revertCacheKey((String)tagCacheKey);
        String cacheKey = (String)taskIdAndCacheKey.getRight();
        if (StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            this.taskInstanceDao.clearCacheByCacheKey(cacheKey);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return new TaskInstanceRemoveCacheResponse(result, cacheKey);
    }

    @Override
    public void deleteByWorkflowInstanceId(Integer workflowInstanceId) {
        List needToDeleteTaskInstances = this.taskInstanceDao.queryByWorkflowInstanceId(workflowInstanceId);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)needToDeleteTaskInstances)) {
            return;
        }
        for (TaskInstance taskInstance : needToDeleteTaskInstances) {
            if (!StringUtils.isNotBlank((CharSequence)taskInstance.getLogPath())) continue;
            ILogService iLogService = (ILogService)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ILogService.class);
            iLogService.removeTaskInstanceLog(taskInstance.getLogPath());
        }
        this.dqExecuteResultDao.deleteByWorkflowInstanceId(workflowInstanceId);
        this.taskGroupQueueService.deleteByWorkflowInstanceId(workflowInstanceId);
        this.taskInstanceDao.deleteByWorkflowInstanceId(workflowInstanceId.intValue());
    }
}

