/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.UDFUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UdfFuncServiceImpl
extends BaseServiceImpl
implements UdfFuncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UdfFuncServiceImpl.class);
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private UDFUserMapper udfUserMapper;
    @Autowired(required=false)
    private StorageOperate storageOperate;

    @Override
    @Transactional
    public Result<Object> createUdfFunction(User loginUser, String funcName, String className, String fullName, String argTypes, String database, String desc, UdfType type) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.UDF, "resources:udf-func:create");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        if (this.checkUdfFuncNameExists(funcName)) {
            log.warn("Udf function with the same name already exists.");
            this.putMsg((Result)result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
            return result;
        }
        Boolean existResource = false;
        try {
            existResource = this.storageOperate.exists(fullName);
        }
        catch (IOException e) {
            log.error("Check resource error: {}", (Object)fullName, (Object)e);
        }
        if (!existResource.booleanValue()) {
            log.error("resource full name {} is not exist", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        UdfFunc udf = new UdfFunc();
        Date now = new Date();
        udf.setUserId(loginUser.getId().intValue());
        udf.setFuncName(funcName);
        udf.setClassName(className);
        if (!StringUtils.isEmpty((CharSequence)argTypes)) {
            udf.setArgTypes(argTypes);
        }
        if (!StringUtils.isEmpty((CharSequence)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(-1);
        udf.setResourceName(fullName);
        udf.setType(type);
        udf.setCreateTime(now);
        udf.setUpdateTime(now);
        this.udfFuncMapper.insert((Object)udf);
        log.info("UDF function create complete, udfFuncName:{}.", (Object)udf.getFuncName());
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkUdfFuncNameExists(String name) {
        List resource = this.udfFuncMapper.queryUdfByIdStr(null, name);
        return resource != null && !resource.isEmpty();
    }

    @Override
    public Result<Object> queryUdfFuncDetail(User loginUser, int id) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.UDF, "resources:udf-func:view");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        UdfFunc udfFunc = (UdfFunc)this.udfFuncMapper.selectById((Serializable)Integer.valueOf(id));
        if (udfFunc == null) {
            log.error("Resource does not exist, udf func id:{}.", (Object)id);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        result.setData(udfFunc);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> updateUdfFunc(User loginUser, int udfFuncId, String funcName, String className, String argTypes, String database, String desc, UdfType type, String fullName) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, new Object[]{udfFuncId}, AuthorizationType.UDF, "resources:udf-func:update");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            log.warn("Parameter description is too long.");
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        UdfFunc udf = this.udfFuncMapper.selectUdfById(udfFuncId);
        if (udf == null) {
            log.error("UDF function does not exist, udfFuncId:{}.", (Object)udfFuncId);
            result.setCode(Status.UDF_FUNCTION_NOT_EXIST.getCode());
            result.setMsg(Status.UDF_FUNCTION_NOT_EXIST.getMsg());
            return result;
        }
        if (!funcName.equals(udf.getFuncName()) && this.checkUdfFuncNameExists(funcName)) {
            log.warn("Udf function exists, can not create again, udfFuncName:{}.", (Object)funcName);
            result.setCode(Status.UDF_FUNCTION_EXISTS.getCode());
            result.setMsg(Status.UDF_FUNCTION_EXISTS.getMsg());
            return result;
        }
        Boolean doesResExist = false;
        try {
            doesResExist = this.storageOperate.exists(fullName);
        }
        catch (Exception e) {
            log.error("udf resource :{} checking error", (Object)fullName, (Object)e);
            result.setCode(Status.RESOURCE_NOT_EXIST.getCode());
            result.setMsg(Status.RESOURCE_NOT_EXIST.getMsg());
            return result;
        }
        if (!doesResExist.booleanValue()) {
            log.error("resource full name {} is not exist", (Object)fullName);
            result.setCode(Status.RESOURCE_NOT_EXIST.getCode());
            result.setMsg(Status.RESOURCE_NOT_EXIST.getMsg());
            return result;
        }
        Date now = new Date();
        udf.setFuncName(funcName);
        udf.setClassName(className);
        udf.setArgTypes(argTypes);
        if (!StringUtils.isEmpty((CharSequence)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(-1);
        udf.setResourceName(fullName);
        udf.setType(type);
        udf.setUpdateTime(now);
        this.udfFuncMapper.updateById((Object)udf);
        log.info("UDF function update complete, udfFuncId:{}, udfFuncName:{}.", (Object)udfFuncId, (Object)funcName);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryUdfFuncListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.UDF, "resources:udf-func:view");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage<UdfFunc> udfFuncList = this.getUdfFuncsPage(loginUser, searchVal, pageSize, pageNo);
        pageInfo.setTotal((int)udfFuncList.getTotal());
        pageInfo.setTotalList(udfFuncList.getRecords());
        result.setData(pageInfo);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private IPage<UdfFunc> getUdfFuncsPage(User loginUser, String searchVal, Integer pageSize, int pageNo) {
        Set udfFuncIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.UDF, loginUser.getId(), log);
        Page page = new Page((long)pageNo, (long)pageSize.intValue());
        if (udfFuncIds.isEmpty()) {
            return page;
        }
        return this.udfFuncMapper.queryUdfFuncPaging((IPage)page, new ArrayList(udfFuncIds), searchVal);
    }

    @Override
    public Result<Object> queryUdfFuncList(User loginUser, Integer type) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.UDF, "resources:udf-func:view");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        Set udfFuncIds = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.UDF, loginUser.getId(), log);
        if (udfFuncIds.isEmpty()) {
            result.setData(Collections.emptyList());
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            return result;
        }
        List udfFuncList = this.udfFuncMapper.getUdfFuncByType(new ArrayList(udfFuncIds), type);
        result.setData(udfFuncList);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Result<Object> delete(User loginUser, int id) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.UDF, "resources:udf-func:delete");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        this.udfFuncMapper.deleteById((Serializable)Integer.valueOf(id));
        this.udfUserMapper.deleteByUdfFuncId(id);
        log.info("UDF function delete complete, udfFuncId:{}.", (Object)id);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyUdfFuncByName(User loginUser, String name) {
        Result<Object> result = new Result<Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.UDF, "resources:udf-func:view");
        if (!canOperatorPermissions) {
            this.putMsg((Result)result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        if (this.checkUdfFuncNameExists(name)) {
            log.warn("Udf function with the same already exists.");
            this.putMsg((Result)result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }
}

