/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.job.db;

import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.job.db.BaseDataSource;
import org.apache.dolphinscheduler.common.job.db.ClickHouseDataSource;
import org.apache.dolphinscheduler.common.job.db.HiveDataSource;
import org.apache.dolphinscheduler.common.job.db.MySQLDataSource;
import org.apache.dolphinscheduler.common.job.db.OracleDataSource;
import org.apache.dolphinscheduler.common.job.db.PostgreDataSource;
import org.apache.dolphinscheduler.common.job.db.SQLServerDataSource;
import org.apache.dolphinscheduler.common.job.db.SparkDataSource;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);

    public static BaseDataSource getDatasource(DbType dbType, String parameter) {
        try {
            switch (dbType) {
                case MYSQL: {
                    return JSONUtils.parseObject(parameter, MySQLDataSource.class);
                }
                case POSTGRESQL: {
                    return JSONUtils.parseObject(parameter, PostgreDataSource.class);
                }
                case HIVE: {
                    return JSONUtils.parseObject(parameter, HiveDataSource.class);
                }
                case SPARK: {
                    return JSONUtils.parseObject(parameter, SparkDataSource.class);
                }
                case CLICKHOUSE: {
                    return JSONUtils.parseObject(parameter, ClickHouseDataSource.class);
                }
                case ORACLE: {
                    return JSONUtils.parseObject(parameter, OracleDataSource.class);
                }
                case SQLSERVER: {
                    return JSONUtils.parseObject(parameter, SQLServerDataSource.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error("get datasource object error", (Throwable)e);
            return null;
        }
    }

    public static void loadClass(DbType dbType) throws Exception {
        switch (dbType) {
            case MYSQL: {
                Class.forName("com.mysql.jdbc.Driver");
                break;
            }
            case POSTGRESQL: {
                Class.forName("org.postgresql.Driver");
                break;
            }
            case HIVE: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case SPARK: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case CLICKHOUSE: {
                Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                break;
            }
            case ORACLE: {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                break;
            }
            case SQLSERVER: {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                break;
            }
            default: {
                logger.error("not support sql type: {},can't load class", (Object)dbType);
                throw new IllegalArgumentException("not support sql type,can't load class");
            }
        }
    }
}

