/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.job.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.job.db.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerDataSource
extends BaseDataSource {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerDataSource.class);

    @Override
    public String getJdbcUrl() {
        String jdbcUrl = this.getAddress();
        jdbcUrl = jdbcUrl + ";databaseName=" + this.getDatabase();
        if (StringUtils.isNotEmpty((CharSequence)this.getOther())) {
            jdbcUrl = jdbcUrl + ";" + this.getOther();
        }
        return jdbcUrl;
    }

    @Override
    public void isConnectable() throws Exception {
        Connection con = null;
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            con = DriverManager.getConnection(this.getJdbcUrl(), this.getUser(), this.getPassword());
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error("SQL Server datasource try conn close conn error", (Throwable)e);
                    throw e;
                }
            }
        }
    }
}

