/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.queue;

import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.queue.TaskQueueZkImpl;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueueFactory {
    private static final Logger logger = LoggerFactory.getLogger(TaskQueueFactory.class);

    private TaskQueueFactory() {
    }

    public static ITaskQueue getTaskQueueInstance() {
        String queueImplValue = CommonUtils.getQueueImplValue();
        if (StringUtils.isNotBlank((String)queueImplValue)) {
            logger.info("task queue impl use zookeeper ");
            return TaskQueueZkImpl.getInstance();
        }
        logger.error("property dolphinscheduler.queue.impl can't be blank, system will exit ");
        System.exit(-1);
        return null;
    }
}

