/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.lang.StringUtils;

public class CollectionUtils {
    public static <T> Collection<T> subtract(Set<T> a, Set<T> b) {
        return org.apache.commons.collections4.CollectionUtils.subtract(a, b);
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static Map<String, String> stringToMap(String str, String separator) {
        return CollectionUtils.stringToMap(str, separator, "");
    }

    public static Map<String, String> stringToMap(String str, String separator, String keyPrefix) {
        if (null == str || "".equals(str)) {
            return null;
        }
        if (null == separator || "".equals(separator)) {
            return null;
        }
        String[] strings = str.split(separator);
        int mapLength = strings.length;
        if (strings.length % 2 != 0) {
            ++mapLength;
        }
        HashMap<String, String> map = new HashMap<String, String>(mapLength);
        for (int i = 0; i < strings.length; ++i) {
            String[] strArray = strings[i].split("=");
            if (StringUtils.isEmpty((String)keyPrefix)) {
                map.put(strArray[0], strArray[1]);
                continue;
            }
            map.put(keyPrefix + strArray[0], strArray[1]);
        }
        return map;
    }

    public static boolean equalLists(Collection<?> a, Collection<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(a, b);
    }

    public static boolean isEqualCollection(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        CardinalityHelper helper = new CardinalityHelper(a, b);
        if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
            return false;
        }
        for (Object obj : helper.cardinalityA.keySet()) {
            if (helper.freqA(obj) == helper.freqB(obj)) continue;
            return false;
        }
        return true;
    }

    public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> coll) {
        HashMap<O, Integer> count = new HashMap<O, Integer>();
        for (O obj : coll) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, 1);
                continue;
            }
            count.put(obj, c + 1);
        }
        return count;
    }

    public static <T> List<Map<String, Object>> getListByExclusion(List<T> originList, Set<String> exclusionSet) {
        ArrayList<Map<String, Object>> instanceList = new ArrayList<Map<String, Object>>();
        for (T instance : originList) {
            BeanMap dataMap = new BeanMap(instance);
            LinkedHashMap instanceMap = new LinkedHashMap(16, 0.75f, true);
            for (Map.Entry entry : dataMap.entrySet()) {
                if (exclusionSet.contains(entry.getKey())) continue;
                instanceMap.put(entry.getKey(), entry.getValue());
            }
            instanceList.add(instanceMap);
        }
        return instanceList;
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        public CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = CollectionUtils.getCardinalityMap(a);
            this.cardinalityB = CollectionUtils.getCardinalityMap(b);
        }

        public final int max(Object obj) {
            return Math.max(this.freqA(obj), this.freqB(obj));
        }

        public final int min(Object obj) {
            return Math.min(this.freqA(obj), this.freqB(obj));
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private final int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

