/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    public static final Logger logger = LoggerFactory.getLogger(ConnectionUtils.class);
    private static ConnectionUtils instance;

    ConnectionUtils() {
    }

    public static ConnectionUtils getInstance() {
        if (null == instance) {
            ConnectionUtils.syncInit();
        }
        return instance;
    }

    private static synchronized void syncInit() {
        if (instance == null) {
            instance = new ConnectionUtils();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(ResultSet rs, Statement stmt, Connection conn) {
        try {
            if (rs == null) return;
            rs.close();
            rs = null;
            return;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void releaseResource(ResultSet rs, PreparedStatement ps, Connection conn) {
        ConnectionUtils.getInstance().release(rs, ps, conn);
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

