/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);

    private static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    private static Date localDateTime2Date(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static String getCurrentTime() {
        return DateUtils.getCurrentTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentTime(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String format(Date date, String format) {
        return DateUtils.format(DateUtils.date2LocalDateTime(date), format);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String dateToString(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parse(String date, String format) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(date, DateTimeFormatter.ofPattern(format));
            return DateUtils.localDateTime2Date(ldt);
        }
        catch (Exception e) {
            logger.error("error while parse date:" + date, (Throwable)e);
            return null;
        }
    }

    public static Date stringToDate(String str) {
        return DateUtils.parse(str, "yyyy-MM-dd HH:mm:ss");
    }

    public static long differSec(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return 0L;
        }
        return (long)Math.ceil((double)DateUtils.differMs(d1, d2) / 1000.0);
    }

    public static long differMs(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime());
    }

    public static long diffHours(Date d1, Date d2) {
        return (long)Math.ceil((double)DateUtils.diffMin(d1, d2) / 60.0);
    }

    public static long diffMin(Date d1, Date d2) {
        return (long)Math.ceil((double)DateUtils.differSec(d1, d2) / 60.0);
    }

    public static Date getSomeDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static boolean compare(Date future, Date old) {
        return future.getTime() > old.getTime();
    }

    public static Date getScheduleDate(String schedule) {
        return DateUtils.stringToDate(schedule);
    }

    public static String format2Readable(long ms) {
        long days = ms / 86400000L;
        long hours = ms % 86400000L / 3600000L;
        long minutes = ms % 3600000L / 60000L;
        long seconds = ms % 60000L / 1000L;
        return String.format("%02d %02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static Date getMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 1);
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getSomeHourOfDay(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, cal.get(11) - hours);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfDay(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getStartOfHour(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfHour(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }
}

