/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HttpUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.cli.RMAdminCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HadoopUtils.class);
    private static String hdfsUser = PropertyUtils.getString("hdfs.root.user");
    private static volatile HadoopUtils instance = new HadoopUtils();
    private static volatile Configuration configuration;
    private static FileSystem fs;

    private HadoopUtils() {
        if (StringUtils.isEmpty((CharSequence)hdfsUser)) {
            hdfsUser = PropertyUtils.getString("hdfs.root.user");
        }
        this.init();
        this.initHdfsPath();
    }

    public static HadoopUtils getInstance() {
        if (CommonUtils.getKerberosStartupState()) {
            return new HadoopUtils();
        }
        return instance;
    }

    private void initHdfsPath() {
        String hdfsPath = PropertyUtils.getString("data.store2hdfs.basepath");
        Path path = new Path(hdfsPath);
        try {
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        if (configuration != null) return;
        Class<HadoopUtils> clazz = HadoopUtils.class;
        synchronized (HadoopUtils.class) {
            if (configuration != null) return;
            try {
                configuration = new Configuration();
                String resUploadStartupType = PropertyUtils.getString("res.upload.startup.type");
                ResUploadType resUploadType = ResUploadType.valueOf(resUploadStartupType);
                if (resUploadType == ResUploadType.HDFS) {
                    String defaultFS;
                    if (PropertyUtils.getBoolean("hadoop.security.authentication.startup.state").booleanValue()) {
                        System.setProperty("java.security.krb5.conf", PropertyUtils.getString("java.security.krb5.conf.path"));
                        configuration.set("hadoop.security.authentication", "kerberos");
                        UserGroupInformation.setConfiguration((Configuration)configuration);
                        UserGroupInformation.loginUserFromKeytab((String)PropertyUtils.getString("login.user.keytab.username"), (String)PropertyUtils.getString("login.user.keytab.path"));
                    }
                    if ((defaultFS = configuration.get("fs.defaultFS")).startsWith("file")) {
                        String defaultFSProp = PropertyUtils.getString("fs.defaultFS");
                        if (!StringUtils.isNotBlank((CharSequence)defaultFSProp)) {
                            logger.error("property:{} can not to be empty, please set!");
                            throw new RuntimeException("property:{} can not to be empty, please set!");
                        }
                        Map<String, String> fsRelatedProps = PropertyUtils.getPrefixedProperties("fs.");
                        configuration.set("fs.defaultFS", defaultFSProp);
                        fsRelatedProps.entrySet().stream().forEach(entry -> configuration.set((String)entry.getKey(), (String)entry.getValue()));
                    } else {
                        logger.info("get property:{} -> {}, from core-site.xml hdfs-site.xml ", (Object)"fs.defaultFS", (Object)defaultFS);
                    }
                    if (fs == null) {
                        if (StringUtils.isNotEmpty((CharSequence)hdfsUser)) {
                            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)hdfsUser);
                            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws Exception {
                                    fs = FileSystem.get((Configuration)configuration);
                                    return true;
                                }
                            });
                        } else {
                            logger.warn("hdfs.root.user is not set value!");
                            fs = FileSystem.get((Configuration)configuration);
                        }
                    }
                } else if (resUploadType == ResUploadType.S3) {
                    configuration.set("fs.defaultFS", PropertyUtils.getString("fs.defaultFS"));
                    configuration.set("fs.s3a.endpoint", PropertyUtils.getString("fs.s3a.endpoint"));
                    configuration.set("fs.s3a.access.key", PropertyUtils.getString("fs.s3a.access.key"));
                    configuration.set("fs.s3a.secret.key", PropertyUtils.getString("fs.s3a.secret.key"));
                    fs = FileSystem.get((Configuration)configuration);
                }
                String rmHaIds = PropertyUtils.getString("yarn.resourcemanager.ha.rm.ids");
                String appAddress = PropertyUtils.getString("yarn.application.status.address");
                if (!StringUtils.isEmpty((CharSequence)rmHaIds)) {
                    appAddress = HadoopUtils.getAppAddress(appAddress, rmHaIds);
                    logger.info("appAddress : {}", (Object)appAddress);
                }
                configuration.set("yarn.application.status.address", appAddress);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public String getApplicationUrl(String applicationId) {
        return String.format(configuration.get("yarn.application.status.address"), applicationId);
    }

    public byte[] catFile(String hdfsFilePath) throws IOException {
        if (StringUtils.isBlank((CharSequence)hdfsFilePath)) {
            logger.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return null;
        }
        FSDataInputStream fsDataInputStream = fs.open(new Path(hdfsFilePath));
        return IOUtils.toByteArray((InputStream)fsDataInputStream);
    }

    public List<String> catFile(String hdfsFilePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)hdfsFilePath)) {
            logger.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return null;
        }
        FSDataInputStream in = fs.open(new Path(hdfsFilePath));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in));
        Stream<String> stream = br.lines().skip(skipLineNums).limit(limit);
        return stream.collect(Collectors.toList());
    }

    public boolean mkdir(String hdfsPath) throws IOException {
        return fs.mkdirs(new Path(hdfsPath));
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        return FileUtil.copy((FileSystem)fs, (Path)new Path(srcPath), (FileSystem)fs, (Path)new Path(dstPath), (boolean)deleteSource, (boolean)overwrite, (Configuration)fs.getConf());
    }

    public boolean copyLocalToHdfs(String srcFile, String dstHdfsPath, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcFile);
        Path dstPath = new Path(dstHdfsPath);
        fs.copyFromLocalFile(deleteSource, overwrite, srcPath, dstPath);
        return true;
    }

    public boolean copyHdfsToLocal(String srcHdfsFilePath, String dstFile, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcHdfsFilePath);
        File dstPath = new File(dstFile);
        if (dstPath.exists()) {
            if (dstPath.isFile()) {
                if (overwrite) {
                    dstPath.delete();
                }
            } else {
                logger.error("destination file must be a file");
            }
        }
        if (!dstPath.getParentFile().exists()) {
            dstPath.getParentFile().mkdirs();
        }
        return FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dstPath, (boolean)deleteSource, (Configuration)fs.getConf());
    }

    public boolean delete(String hdfsFilePath, boolean recursive) throws IOException {
        return fs.delete(new Path(hdfsFilePath), recursive);
    }

    public boolean exists(String hdfsFilePath) throws IOException {
        return fs.exists(new Path(hdfsFilePath));
    }

    public FileStatus[] listFileStatus(String filePath) throws Exception {
        Path path = new Path(filePath);
        try {
            return fs.listStatus(new Path(filePath));
        }
        catch (IOException e) {
            logger.error("Get file list exception", (Throwable)e);
            throw new Exception("Get file list exception", e);
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        return fs.rename(new Path(src), new Path(dst));
    }

    public ExecutionStatus getApplicationStatus(String applicationId) throws JSONException {
        String result;
        if (StringUtils.isEmpty((CharSequence)applicationId)) {
            return null;
        }
        String applicationUrl = this.getApplicationUrl(applicationId);
        String responseContent = HttpUtils.get(applicationUrl);
        JSONObject jsonObject = JSONObject.parseObject((String)responseContent);
        switch (result = jsonObject.getJSONObject("app").getString("finalStatus")) {
            case "ACCEPTED": {
                return ExecutionStatus.SUBMITTED_SUCCESS;
            }
            case "SUCCEEDED": {
                return ExecutionStatus.SUCCESS;
            }
            case "NEW": 
            case "NEW_SAVING": 
            case "SUBMITTED": 
            case "FAILED": {
                return ExecutionStatus.FAILURE;
            }
            case "KILLED": {
                return ExecutionStatus.KILL;
            }
        }
        return ExecutionStatus.RUNNING_EXEUTION;
    }

    public static String getHdfsDataBasePath() {
        String basePath = PropertyUtils.getString("data.store2hdfs.basepath");
        if ("/".equals(basePath)) {
            return "";
        }
        return basePath;
    }

    public static String getHdfsResDir(String tenantCode) {
        return String.format("%s/resources", HadoopUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsUserDir(String tenantCode, int userId) {
        return String.format("%s/home/%d", HadoopUtils.getHdfsTenantDir(tenantCode), userId);
    }

    public static String getHdfsUdfDir(String tenantCode) {
        return String.format("%s/udfs", HadoopUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsFilename(String tenantCode, String filename) {
        return String.format("%s/%s", HadoopUtils.getHdfsResDir(tenantCode), filename);
    }

    public static String getHdfsUdfFilename(String tenantCode, String filename) {
        return String.format("%s/%s", HadoopUtils.getHdfsUdfDir(tenantCode), filename);
    }

    public static String getHdfsTenantDir(String tenantCode) {
        return String.format("%s/%s", HadoopUtils.getHdfsDataBasePath(), tenantCode);
    }

    public static String getAppAddress(String appAddress, String rmHa) {
        String activeRM = YarnHAAdminUtils.getAcitveRMName(rmHa);
        String[] split1 = appAddress.split("//");
        if (split1.length != 2) {
            return null;
        }
        String start = split1[0] + "//";
        String[] split2 = split1[1].split(":");
        if (split2.length != 2) {
            return null;
        }
        String end = ":" + split2[1];
        return start + activeRM + end;
    }

    @Override
    public void close() throws IOException {
        if (fs != null) {
            try {
                fs.close();
            }
            catch (IOException e) {
                logger.error("Close HadoopUtils instance failed", (Throwable)e);
                throw new IOException("Close HadoopUtils instance failed", e);
            }
        }
    }

    private static final class YarnHAAdminUtils
    extends RMAdminCLI {
        private static final Logger logger = LoggerFactory.getLogger(YarnHAAdminUtils.class);

        private YarnHAAdminUtils() {
        }

        public static String getAcitveRMName(String rmIds) {
            block5: {
                String[] rmIdArr = rmIds.split(",");
                int activeResourceManagerPort = PropertyUtils.getInt("resource.manager.httpaddress.port", 8088);
                String yarnUrl = "http://%s:" + activeResourceManagerPort + "/ws/v1/cluster/info";
                String state = null;
                try {
                    state = YarnHAAdminUtils.getRMState(String.format(yarnUrl, rmIdArr[0]));
                    if ("ACTIVE".equals(state)) {
                        return rmIdArr[0];
                    }
                    if ("STANDBY".equals(state)) {
                        state = YarnHAAdminUtils.getRMState(String.format(yarnUrl, rmIdArr[1]));
                        if ("ACTIVE".equals(state)) {
                            return rmIdArr[1];
                        }
                        break block5;
                    }
                    return null;
                }
                catch (Exception e) {
                    state = YarnHAAdminUtils.getRMState(String.format(yarnUrl, rmIdArr[1]));
                    if (!"ACTIVE".equals(state)) break block5;
                    return rmIdArr[0];
                }
            }
            return null;
        }

        public static String getRMState(String url) {
            String retStr = HttpUtils.get(url);
            if (StringUtils.isEmpty((CharSequence)retStr)) {
                return null;
            }
            JSONObject jsonObject = JSON.parseObject((String)retStr);
            String state = jsonObject.getJSONObject("clusterInfo").getString("haState");
            return state;
        }
    }
}

