/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();
    private static final PropertyUtils propertyUtils = new PropertyUtils();

    private PropertyUtils() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String[] propertyFiles;
        for (String fileName : propertyFiles = new String[]{"/common/hadoop/hadoop.properties", "/common/common.properties"}) {
            InputStream fis = null;
            try {
                fis = PropertyUtils.class.getResourceAsStream(fileName);
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (fis != null) {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                System.exit(1);
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
    }

    public static Boolean getResUploadStartupState() {
        String resUploadStartupType = PropertyUtils.getString("res.upload.startup.type");
        ResUploadType resUploadType = ResUploadType.valueOf(resUploadStartupType);
        return resUploadType == ResUploadType.HDFS || resUploadType == ResUploadType.S3;
    }

    public static String getString(String key) {
        return properties.getProperty(key.trim());
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static Boolean getBoolean(String key) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static long getLong(String key, long defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    public static long getLong(String key) {
        return PropertyUtils.getLong(key, -1L);
    }

    public double getDouble(String key, double defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Double.parseDouble(val);
    }

    public static String[] getArray(String key, String splitStr) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return new String[0];
        }
        try {
            String[] propertyArray = value.split(splitStr);
            return propertyArray;
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultValue : Enum.valueOf(type, val);
    }

    public static Map<String, String> getPrefixedProperties(String prefix) {
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith(prefix)) continue;
            matchedProperties.put(propName, properties.getProperty(propName));
        }
        return matchedProperties;
    }
}

