/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import org.apache.commons.lang3.EnumUtils;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.common.task.http.HttpParameters;
import org.apache.dolphinscheduler.common.task.mr.MapreduceParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.task.python.PythonParameters;
import org.apache.dolphinscheduler.common.task.shell.ShellParameters;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlParameters;
import org.apache.dolphinscheduler.common.task.subprocess.SubProcessParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskParametersUtils {
    private static Logger logger = LoggerFactory.getLogger(TaskParametersUtils.class);

    public static AbstractParameters getParameters(String taskType, String parameter) {
        try {
            switch ((TaskType)EnumUtils.getEnum(TaskType.class, (String)taskType)) {
                case SUB_PROCESS: {
                    return JSONUtils.parseObject(parameter, SubProcessParameters.class);
                }
                case SHELL: {
                    return JSONUtils.parseObject(parameter, ShellParameters.class);
                }
                case PROCEDURE: {
                    return JSONUtils.parseObject(parameter, ProcedureParameters.class);
                }
                case SQL: {
                    return JSONUtils.parseObject(parameter, SqlParameters.class);
                }
                case MR: {
                    return JSONUtils.parseObject(parameter, MapreduceParameters.class);
                }
                case SPARK: {
                    return JSONUtils.parseObject(parameter, SparkParameters.class);
                }
                case PYTHON: {
                    return JSONUtils.parseObject(parameter, PythonParameters.class);
                }
                case DEPENDENT: {
                    return JSONUtils.parseObject(parameter, DependentParameters.class);
                }
                case FLINK: {
                    return JSONUtils.parseObject(parameter, FlinkParameters.class);
                }
                case HTTP: {
                    return JSONUtils.parseObject(parameter, HttpParameters.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

