/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.dependent;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.utils.DateUtils;

public class DependentDateUtils {
    public static List<DateInterval> getLastHoursInterval(Date businessDate, int hourNumber) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        for (int index = hourNumber; index > 0; --index) {
            Date lastHour = DateUtils.getSomeHourOfDay(businessDate, index);
            Date beginTime = DateUtils.getStartOfHour(lastHour);
            Date endTime = DateUtils.getEndOfHour(lastHour);
            dateIntervals.add(new DateInterval(beginTime, endTime));
        }
        return dateIntervals;
    }

    public static List<DateInterval> getTodayInterval(Date businessDate) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        Date beginTime = DateUtils.getStartOfDay(businessDate);
        Date endTime = DateUtils.getEndOfDay(businessDate);
        dateIntervals.add(new DateInterval(beginTime, endTime));
        return dateIntervals;
    }

    public static List<DateInterval> getLastDayInterval(Date businessDate, int someDay) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        for (int index = someDay; index > 0; --index) {
            Date lastDay = DateUtils.getSomeDay(businessDate, -index);
            Date beginTime = DateUtils.getStartOfDay(lastDay);
            Date endTime = DateUtils.getEndOfDay(lastDay);
            dateIntervals.add(new DateInterval(beginTime, endTime));
        }
        return dateIntervals;
    }

    public static List<DateInterval> getThisMonthInterval(Date businessDate) {
        Date firstDay = DateUtils.getFirstDayOfMonth(businessDate);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, businessDate);
    }

    public static List<DateInterval> getLastMonthInterval(Date businessDate) {
        Date firstDayThisMonth = DateUtils.getFirstDayOfMonth(businessDate);
        Date lastDay = DateUtils.getSomeDay(firstDayThisMonth, -1);
        Date firstDay = DateUtils.getFirstDayOfMonth(lastDay);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, lastDay);
    }

    public static List<DateInterval> getLastMonthBeginInterval(Date businessDate, boolean isBeginDay) {
        Date firstDayThisMonth = DateUtils.getFirstDayOfMonth(businessDate);
        Date lastDay = DateUtils.getSomeDay(firstDayThisMonth, -1);
        Date firstDay = DateUtils.getFirstDayOfMonth(lastDay);
        if (isBeginDay) {
            return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, firstDay);
        }
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(lastDay, lastDay);
    }

    public static List<DateInterval> getThisWeekInterval(Date businessDate) {
        Date mondayThisWeek = DateUtils.getMonday(businessDate);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(mondayThisWeek, businessDate);
    }

    public static List<DateInterval> getLastWeekInterval(Date businessDate) {
        Date mondayThisWeek = DateUtils.getMonday(businessDate);
        Date sunday = DateUtils.getSomeDay(mondayThisWeek, -1);
        Date monday = DateUtils.getMonday(sunday);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(monday, sunday);
    }

    public static List<DateInterval> getLastWeekOneDayInterval(Date businessDate, int dayOfWeek) {
        Date mondayThisWeek = DateUtils.getMonday(businessDate);
        Date sunday = DateUtils.getSomeDay(mondayThisWeek, -1);
        Date monday = DateUtils.getMonday(sunday);
        Date destDay = DateUtils.getSomeDay(monday, dayOfWeek - 1);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(destDay, destDay);
    }

    public static List<DateInterval> getDateIntervalListBetweenTwoDates(Date firstDay, Date lastDay) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        while (!firstDay.after(lastDay)) {
            Date beginTime = DateUtils.getStartOfDay(firstDay);
            Date endTime = DateUtils.getEndOfDay(firstDay);
            dateIntervals.add(new DateInterval(beginTime, endTime));
            firstDay = DateUtils.getSomeDay(firstDay, 1);
        }
        return dateIntervals;
    }
}

