/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.placeholder;

import java.util.Map;
import org.apache.dolphinscheduler.common.utils.placeholder.PropertyPlaceholderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderUtils {
    private static final Logger logger = LoggerFactory.getLogger(PlaceholderUtils.class);
    public static final String placeholderPrefix = "${";
    public static final String placeholderSuffix = "}";

    public static String replacePlaceholders(String value, Map<String, String> paramsMap, boolean ignoreUnresolvablePlaceholders) {
        PropertyPlaceholderHelper strictHelper = PlaceholderUtils.getPropertyPlaceholderHelper(false);
        PropertyPlaceholderHelper nonStrictHelper = PlaceholderUtils.getPropertyPlaceholderHelper(true);
        PropertyPlaceholderHelper helper = ignoreUnresolvablePlaceholders ? nonStrictHelper : strictHelper;
        return helper.replacePlaceholders(value, new PropertyPlaceholderResolver(value, paramsMap));
    }

    public static PropertyPlaceholderHelper getPropertyPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(placeholderPrefix, placeholderSuffix, null, ignoreUnresolvablePlaceholders);
    }

    private static class PropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String value;
        private final Map<String, String> paramsMap;

        public PropertyPlaceholderResolver(String value, Map<String, String> paramsMap) {
            this.value = value;
            this.paramsMap = paramsMap;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            try {
                return this.paramsMap.get(placeholderName);
            }
            catch (Exception ex) {
                logger.error(String.format("resolve placeholder '%s' in [ %s ]", placeholderName, this.value), (Throwable)ex);
                return null;
            }
        }
    }
}

