/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;

public enum TaskType {
    SHELL(0, "shell"),
    SQL(1, "sql"),
    SUB_PROCESS(2, "sub process"),
    PROCEDURE(3, "procedure"),
    MR(4, "mr"),
    SPARK(5, "spark"),
    PYTHON(6, "python"),
    DEPENDENT(7, "dependent"),
    FLINK(8, "flink"),
    HTTP(9, "http");

    @EnumValue
    private final int code;
    private final String descp;

    private TaskType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static boolean typeIsNormalTask(String typeName) {
        TaskType taskType = TaskType.valueOf(typeName);
        return taskType != SUB_PROCESS && taskType != DEPENDENT;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }
}

