/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setRedirectsEnabled(true).build();
        httpget.setConfig(requestConfig);
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                } else {
                    logger.warn("http entity is null");
                }
            } else {
                logger.error("htt get:{} response status code is not 200!");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (httpget != null && !httpget.isAborted()) {
                httpget.releaseConnection();
                httpget.abort();
            }
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }
}

