/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.shell.ShellExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

public class OSUtils {
    private static final Logger logger = LoggerFactory.getLogger(OSUtils.class);
    private static final SystemInfo SI = new SystemInfo();
    public static final String TWO_DECIMAL = "0.00";
    private static HardwareAbstractionLayer hal = SI.getHardware();

    private OSUtils() {
    }

    public static double memoryUsage() {
        GlobalMemory memory = hal.getMemory();
        double memoryUsage = (double)(memory.getTotal() - memory.getAvailable() - memory.getSwapUsed()) * 0.1 / (double)memory.getTotal() * 10.0;
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(memoryUsage));
    }

    public static double availablePhysicalMemorySize() {
        GlobalMemory memory = hal.getMemory();
        double availablePhysicalMemorySize = (double)(memory.getAvailable() + memory.getSwapUsed()) / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(availablePhysicalMemorySize));
    }

    public static double totalMemorySize() {
        GlobalMemory memory = hal.getMemory();
        double availablePhysicalMemorySize = (double)memory.getTotal() / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(availablePhysicalMemorySize));
    }

    public static double loadAverage() {
        double loadAverage = hal.getProcessor().getSystemLoadAverage();
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(loadAverage));
    }

    public static double cpuUsage() {
        CentralProcessor processor = hal.getProcessor();
        double cpuUsage = processor.getSystemCpuLoad();
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(cpuUsage));
    }

    public static List<String> getUserList() {
        try {
            if (OSUtils.isMacOS()) {
                return OSUtils.getUserListFromMac();
            }
            if (!OSUtils.isWindows()) {
                return OSUtils.getUserListFromLinux();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static List<String> getUserListFromLinux() throws IOException {
        ArrayList<String> userList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/etc/passwd")));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.contains(":")) continue;
                String[] userInfo = line.split(":");
                userList.add(userInfo[0]);
            }
        }
        return userList;
    }

    private static List<String> getUserListFromMac() throws IOException {
        String result = OSUtils.exeCmd("dscl . list /users");
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return Arrays.asList(StringUtils.split((String)result, (String)"\n"));
        }
        return Collections.emptyList();
    }

    public static boolean createUser(String userName) {
        try {
            String userGroup = OSUtils.getGroup();
            if (StringUtils.isEmpty((CharSequence)userGroup)) {
                logger.error("{} group does not exist for this operating system.", (Object)userGroup);
                return false;
            }
            if (OSUtils.isMacOS()) {
                OSUtils.createMacUser(userName, userGroup);
            } else if (!OSUtils.isWindows()) {
                OSUtils.createLinuxUser(userName, userGroup);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void createLinuxUser(String userName, String userGroup) throws IOException {
        logger.info("create linux os user : {}", (Object)userName);
        String cmd = String.format("sudo useradd -g %s %s", userGroup, userName);
        logger.info("execute cmd : {}", (Object)cmd);
        OSUtils.exeCmd(cmd);
    }

    private static void createMacUser(String userName, String userGroup) throws IOException {
        logger.info("create mac os user : {}", (Object)userName);
        String userCreateCmd = String.format("sudo sysadminctl -addUser %s -password %s", userName, userName);
        String appendGroupCmd = String.format("sudo dseditgroup -o edit -a %s -t user %s", userName, userGroup);
        logger.info("create user command : {}", (Object)userCreateCmd);
        OSUtils.exeCmd(userCreateCmd);
        logger.info("append user to group : {}", (Object)appendGroupCmd);
        OSUtils.exeCmd(appendGroupCmd);
    }

    public static String getGroup() throws IOException {
        String result = OSUtils.exeCmd("groups");
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            String[] groupInfo = StringUtils.split((String)result);
            return groupInfo[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exeCmd(String command) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String exeShell(String command) throws IOException {
        return ShellExecutor.execCommand(command);
    }

    public static int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
    }

    public static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isMacOS() {
        String os = System.getProperty("os.name");
        return os.startsWith("Mac");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public static Boolean checkResource(double systemCpuLoad, double systemReservedMemory) {
        double loadAverage = OSUtils.loadAverage();
        double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
        if (loadAverage > systemCpuLoad || availablePhysicalMemorySize < systemReservedMemory) {
            logger.warn("load or availablePhysicalMemorySize(G) is too high, it's availablePhysicalMemorySize(G):{},loadAvg:{}", (Object)availablePhysicalMemorySize, (Object)loadAverage);
            return false;
        }
        return true;
    }

    public static Boolean checkResource(Configuration conf, Boolean isMaster) {
        double systemReservedMemory;
        double systemCpuLoad;
        if (isMaster.booleanValue()) {
            systemCpuLoad = conf.getDouble("master.max.cpuload.avg", (double)Constants.defaultMasterCpuLoad);
            systemReservedMemory = conf.getDouble("master.reserved.memory", Constants.defaultMasterReservedMemory);
        } else {
            systemCpuLoad = conf.getDouble("worker.max.cpuload.avg", (double)Constants.defaultWorkerCpuLoad);
            systemReservedMemory = conf.getDouble("worker.reserved.memory", Constants.defaultWorkerReservedMemory);
        }
        double loadAverage = OSUtils.loadAverage();
        double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
        if (loadAverage > systemCpuLoad || availablePhysicalMemorySize < systemReservedMemory) {
            logger.warn("load or availablePhysicalMemorySize(G) is too high, it's availablePhysicalMemorySize(G):{},loadAvg:{}", (Object)availablePhysicalMemorySize, (Object)loadAverage);
            return false;
        }
        return true;
    }
}

