/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;

public enum CommandType {
    START_PROCESS(0, "start a new process"),
    START_CURRENT_TASK_PROCESS(1, "start a new process from current nodes"),
    RECOVER_TOLERANCE_FAULT_PROCESS(2, "recover tolerance fault process"),
    RECOVER_SUSPENDED_PROCESS(3, "recover suspended process"),
    START_FAILURE_TASK_PROCESS(4, "start process from failure task nodes"),
    COMPLEMENT_DATA(5, "complement data"),
    SCHEDULER(6, "start a new process from scheduler"),
    REPEAT_RUNNING(7, "repeat running a process"),
    PAUSE(8, "pause a process"),
    STOP(9, "stop a process"),
    RECOVER_WAITTING_THREAD(10, "recover waiting thread");

    @EnumValue
    private final int code;
    private final String descp;

    private CommandType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static CommandType of(Integer status) {
        for (CommandType cmdType : CommandType.values()) {
            if (cmdType.getCode() != status.intValue()) continue;
            return cmdType;
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }
}

