/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");

    public static String suffix(String filename) {
        int lastIndex;
        String fileSuffix = "";
        if (StringUtils.isNotEmpty((String)filename) && (lastIndex = filename.lastIndexOf(46)) > 0) {
            fileSuffix = filename.substring(lastIndex + 1);
        }
        return fileSuffix;
    }

    public static String getDownloadFilename(String filename) {
        String fileName = String.format("%s/download/%s/%s", DATA_BASEDIR, DateUtils.getCurrentTime("yyyyMMddHHmmss"), filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getUploadFilename(String tenantCode, String filename) {
        String fileName = String.format("%s/%s/resources/%s", DATA_BASEDIR, tenantCode, filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getProcessExecDir(int projectId, int processDefineId, int processInstanceId, int taskInstanceId) {
        String fileName = String.format("%s/exec/process/%s/%s/%s/%s", DATA_BASEDIR, Integer.toString(projectId), Integer.toString(processDefineId), Integer.toString(processInstanceId), Integer.toString(taskInstanceId));
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getProcessExecDir(int projectId, int processDefineId, int processInstanceId) {
        String fileName = String.format("%s/exec/process/%s/%s/%s", DATA_BASEDIR, Integer.toString(projectId), Integer.toString(processDefineId), Integer.toString(processInstanceId));
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getResourceViewSuffixs() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,conf,cfg,py,java,sql,hql,xml,properties");
    }

    public static void createWorkDirAndUserIfAbsent(String execLocalPath, String userName) throws IOException {
        File execLocalPathFile = new File(execLocalPath);
        if (execLocalPathFile.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)execLocalPathFile);
        }
        org.apache.commons.io.FileUtils.forceMkdir((File)execLocalPathFile);
        logger.info("create dir success {}", (Object)execLocalPath);
        if (!OSUtils.getUserList().contains(userName)) {
            OSUtils.createUser(userName);
        }
        logger.info("create user name success {}", (Object)userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeContent2File(String content, String filePath) {
        BufferedWriter bufferedWriter;
        BufferedReader bufferedReader;
        boolean flag;
        block9: {
            boolean bl;
            block8: {
                flag = true;
                bufferedReader = null;
                bufferedWriter = null;
                try {
                    int len;
                    File distFile = new File(filePath);
                    if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                        logger.error("mkdir parent failed");
                        bl = false;
                        IOUtils.closeQuietly(bufferedWriter);
                        break block8;
                    }
                    bufferedReader = new BufferedReader(new StringReader(content));
                    bufferedWriter = new BufferedWriter(new FileWriter(distFile));
                    char[] buf = new char[1024];
                    while ((len = bufferedReader.read(buf)) != -1) {
                        bufferedWriter.write(buf, 0, len);
                    }
                    bufferedWriter.flush();
                    bufferedReader.close();
                    bufferedWriter.close();
                    IOUtils.closeQuietly((Writer)bufferedWriter);
                    break block9;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    boolean bl2 = flag = false;
                    return bl2;
                }
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
            return bl;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return flag;
        finally {
            IOUtils.closeQuietly(bufferedWriter);
            IOUtils.closeQuietly(bufferedReader);
        }
    }

    public static void writeStringToFile(File file, String data, Charset encoding) throws IOException {
        FileUtils.writeStringToFile(file, data, encoding, false);
    }

    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileUtils.writeStringToFile(file, data, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, Charset encoding, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            IOUtils.write((String)data, (OutputStream)out, (Charset)encoding);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static void writeStringToFile(File file, String data, String encoding, boolean append) throws IOException {
        FileUtils.writeStringToFile(file, data, Charsets.toCharset((String)encoding), append);
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile(file, data, Charset.defaultCharset(), false);
    }

    public static void writeStringToFile(File file, String data, boolean append) throws IOException {
        FileUtils.writeStringToFile(file, data, Charset.defaultCharset(), append);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static void deleteDir(String dir) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)new File(dir));
    }

    public static void deleteFile(String filename) throws IOException {
        org.apache.commons.io.FileUtils.forceDelete((File)new File(filename));
    }

    public static File[] getAllDir(String parentDir) {
        if (parentDir == null || "".equals(parentDir)) {
            throw new RuntimeException("parentDir can not be empty");
        }
        File file = new File(parentDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("parentDir not exist, or is not a directory:" + parentDir);
        }
        return file.listFiles(File::isDirectory);
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

