/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LoggerUtils {
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");
    public static final String TASK_LOGGER_INFO_PREFIX = "TASK";
    public static final String TASK_LOGGER_THREAD_NAME = "TaskLogInfo";
    public static final String TASK_APPID_LOG_FORMAT = "[taskAppId=";

    public static String buildTaskId(String affix, int processDefId, int processInstId, int taskId) {
        return String.format(" - %s%s-%s-%s-%s]", TASK_APPID_LOG_FORMAT, affix, processDefId, processInstId, taskId);
    }

    public static List<String> getAppIds(String log, Logger logger) {
        ArrayList<String> appIds = new ArrayList<String>();
        Matcher matcher = APPLICATION_REGEX.matcher(log);
        while (matcher.find()) {
            String appId = matcher.group();
            if (appIds.contains(appId)) continue;
            logger.info("find app id: {}", (Object)appId);
            appIds.add(appId);
        }
        return appIds;
    }
}

