/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.process;

import com.sun.jna.platform.win32.Kernel32Util;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class ProcessEnvironmentForWin32
extends HashMap<String, String> {
    private static final long serialVersionUID = -8017839552603542824L;
    static final int MIN_NAME_LENGTH = 1;
    private static final NameComparator nameComparator = new NameComparator();
    private static final EntryComparator entryComparator = new EntryComparator();
    private static final ProcessEnvironmentForWin32 theEnvironment = new ProcessEnvironmentForWin32();
    private static final Map<String, String> theUnmodifiableEnvironment = Collections.unmodifiableMap(theEnvironment);
    private static final Map<String, String> theCaseInsensitiveEnvironment;

    private static String validateName(String name) {
        if (name.indexOf(61, 1) != -1 || name.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable name: \"" + name + "\"");
        }
        return name;
    }

    private static String validateValue(String value) {
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable value: \"" + value + "\"");
        }
        return value;
    }

    private static String nonNullString(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return (String)o;
    }

    @Override
    public String put(String key, String value) {
        return super.put(ProcessEnvironmentForWin32.validateName(key), ProcessEnvironmentForWin32.validateValue(value));
    }

    @Override
    public String get(Object key) {
        return (String)super.get(ProcessEnvironmentForWin32.nonNullString(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(ProcessEnvironmentForWin32.nonNullString(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(ProcessEnvironmentForWin32.nonNullString(value));
    }

    @Override
    public String remove(Object key) {
        return (String)super.remove(ProcessEnvironmentForWin32.nonNullString(key));
    }

    @Override
    public Set<String> keySet() {
        return new CheckedKeySet(super.keySet());
    }

    @Override
    public Collection<String> values() {
        return new CheckedValues(super.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new CheckedEntrySet(super.entrySet());
    }

    private ProcessEnvironmentForWin32() {
    }

    private ProcessEnvironmentForWin32(int capacity) {
        super(capacity);
    }

    static String getenv(String name) {
        return theCaseInsensitiveEnvironment.get(name);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return (Map)theEnvironment.clone();
    }

    static Map<String, String> emptyEnvironment(int capacity) {
        return new ProcessEnvironmentForWin32(capacity);
    }

    private static Map<String, String> environmentBlock() {
        return Kernel32Util.getEnvironmentVariables();
    }

    String toEnvironmentBlock() {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(this.entrySet());
        Collections.sort(list, entryComparator);
        StringBuilder sb = new StringBuilder(this.size() * 30);
        int cmp = -1;
        String SYSTEMROOT = "SystemRoot";
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (cmp < 0 && (cmp = nameComparator.compare(key, "SystemRoot")) > 0) {
                ProcessEnvironmentForWin32.addToEnvIfSet(sb, "SystemRoot");
            }
            ProcessEnvironmentForWin32.addToEnv(sb, key, value);
        }
        if (cmp < 0) {
            ProcessEnvironmentForWin32.addToEnvIfSet(sb, "SystemRoot");
        }
        if (sb.length() == 0) {
            sb.append('\u0000');
        }
        sb.append('\u0000');
        return sb.toString();
    }

    private static void addToEnvIfSet(StringBuilder sb, String name) {
        String s = ProcessEnvironmentForWin32.getenv(name);
        if (s != null) {
            ProcessEnvironmentForWin32.addToEnv(sb, name, s);
        }
    }

    private static void addToEnv(StringBuilder sb, String name, String val) {
        sb.append(name).append('=').append(val).append('\u0000');
    }

    static String toEnvironmentBlock(Map<String, String> map) {
        return map == null ? null : ((ProcessEnvironmentForWin32)map).toEnvironmentBlock();
    }

    static {
        theEnvironment.putAll(ProcessEnvironmentForWin32.environmentBlock());
        theCaseInsensitiveEnvironment = new TreeMap<String, String>(nameComparator);
        theCaseInsensitiveEnvironment.putAll(theEnvironment);
    }

    private static final class EntryComparator
    implements Comparator<Map.Entry<String, String>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            return nameComparator.compare(e1.getKey(), e2.getKey());
        }
    }

    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }

    private static class CheckedKeySet
    extends AbstractSet<String> {
        private final Set<String> s;

        public CheckedKeySet(Set<String> s) {
            this.s = s;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.s.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.s.contains(ProcessEnvironmentForWin32.nonNullString(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.s.remove(ProcessEnvironmentForWin32.nonNullString(o));
        }
    }

    private static class CheckedValues
    extends AbstractCollection<String> {
        private final Collection<String> c;

        public CheckedValues(Collection<String> c) {
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.c.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(ProcessEnvironmentForWin32.nonNullString(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.c.remove(ProcessEnvironmentForWin32.nonNullString(o));
        }
    }

    private static class CheckedEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final Set<Map.Entry<String, String>> s;

        public CheckedEntrySet(Set<Map.Entry<String, String>> s) {
            this.s = s;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<Map.Entry<String, String>> i;
                {
                    this.i = s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new CheckedEntry(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        private static Map.Entry<String, String> checkedEntry(Object o) {
            Map.Entry e = (Map.Entry)o;
            ProcessEnvironmentForWin32.nonNullString(e.getKey());
            ProcessEnvironmentForWin32.nonNullString(e.getValue());
            return e;
        }

        @Override
        public boolean contains(Object o) {
            return this.s.contains(CheckedEntrySet.checkedEntry(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.s.remove(CheckedEntrySet.checkedEntry(o));
        }
    }

    private static class CheckedEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<String, String> e;

        public CheckedEntry(Map.Entry<String, String> e) {
            this.e = e;
        }

        @Override
        public String getKey() {
            return this.e.getKey();
        }

        @Override
        public String getValue() {
            return this.e.getValue();
        }

        @Override
        public String setValue(String value) {
            return this.e.setValue(ProcessEnvironmentForWin32.validateValue(value));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }
    }
}

