/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.process;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.process.ProcessBuilderForWin32;
import org.apache.dolphinscheduler.common.utils.process.ProcessEnvironmentForWin32;
import sun.security.action.GetPropertyAction;

public class ProcessImplForWin32
extends Process {
    private static final Field FD_HANDLE;
    private static final int PIPE_SIZE = 4120;
    private static final int HANDLE_STORAGE_SIZE = 6;
    private static final int OFFSET_READ = 0;
    private static final int OFFSET_WRITE = 1;
    private static final WinNT.HANDLE JAVA_INVALID_HANDLE_VALUE;
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_WIN32_SAFE = 2;
    private static final int VERIFICATION_LEGACY = 3;
    private static final char[][] ESCAPE_VERIFICATION;
    private static final char DOUBLEQUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private WinNT.HANDLE handle;
    private OutputStream stdinStream;
    private InputStream stdoutStream;
    private InputStream stderrStream;

    private static void setHandle(FileDescriptor obj, long handle) {
        try {
            FD_HANDLE.set(obj, handle);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static long getHandle(FileDescriptor obj) {
        try {
            return (Long)FD_HANDLE.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileOutputStream newFileOutputStream(File f, boolean append) throws IOException {
        if (append) {
            String path = f.getPath();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkWrite(path);
            }
            long handle = ProcessImplForWin32.openForAtomicAppend(path);
            final FileDescriptor fd = new FileDescriptor();
            ProcessImplForWin32.setHandle(fd, handle);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fd);
                }
            });
        }
        return new FileOutputStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String username, String password, String[] cmdarray, Map<String, String> environment, String dir, ProcessBuilderForWin32.Redirect[] redirects, boolean redirectErrorStream) throws IOException {
        String envblock = ProcessEnvironmentForWin32.toEnvironmentBlock(environment);
        FileInputStream f0 = null;
        FileOutputStream f1 = null;
        FileOutputStream f2 = null;
        try {
            long[] stdHandles;
            if (redirects == null) {
                stdHandles = new long[]{-1L, -1L, -1L};
            } else {
                stdHandles = new long[3];
                if (redirects[0] == ProcessBuilderForWin32.Redirect.PIPE) {
                    stdHandles[0] = -1L;
                } else if (redirects[0] == ProcessBuilderForWin32.Redirect.INHERIT) {
                    stdHandles[0] = ProcessImplForWin32.getHandle(FileDescriptor.in);
                } else {
                    f0 = new FileInputStream(redirects[0].file());
                    stdHandles[0] = ProcessImplForWin32.getHandle(f0.getFD());
                }
                if (redirects[1] == ProcessBuilderForWin32.Redirect.PIPE) {
                    stdHandles[1] = -1L;
                } else if (redirects[1] == ProcessBuilderForWin32.Redirect.INHERIT) {
                    stdHandles[1] = ProcessImplForWin32.getHandle(FileDescriptor.out);
                } else {
                    f1 = ProcessImplForWin32.newFileOutputStream(redirects[1].file(), redirects[1].append());
                    stdHandles[1] = ProcessImplForWin32.getHandle(f1.getFD());
                }
                if (redirects[2] == ProcessBuilderForWin32.Redirect.PIPE) {
                    stdHandles[2] = -1L;
                } else if (redirects[2] == ProcessBuilderForWin32.Redirect.INHERIT) {
                    stdHandles[2] = ProcessImplForWin32.getHandle(FileDescriptor.err);
                } else {
                    f2 = ProcessImplForWin32.newFileOutputStream(redirects[2].file(), redirects[2].append());
                    stdHandles[2] = ProcessImplForWin32.getHandle(f2.getFD());
                }
            }
            ProcessImplForWin32 processImplForWin32 = new ProcessImplForWin32(username, password, cmdarray, envblock, dir, stdHandles, redirectErrorStream);
            return processImplForWin32;
        }
        finally {
            try {
                if (f0 != null) {
                    f0.close();
                }
            }
            finally {
                try {
                    if (f1 != null) {
                        f1.close();
                    }
                }
                finally {
                    if (f2 != null) {
                        f2.close();
                    }
                }
            }
        }
    }

    private static String[] getTokensFromCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>(8);
        Matcher regexMatcher = LazyPattern.PATTERN.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    private static String createCommandLine(int verificationType, String executablePath, String[] cmd) {
        StringBuilder cmdbuf = new StringBuilder(80);
        cmdbuf.append(executablePath);
        for (int i = 1; i < cmd.length; ++i) {
            cmdbuf.append(' ');
            String s = cmd[i];
            if (ProcessImplForWin32.needsEscaping(verificationType, s)) {
                cmdbuf.append('\"');
                if (verificationType == 2) {
                    int length = s.length();
                    for (int j = 0; j < length; ++j) {
                        char c = s.charAt(j);
                        if (c == '\"') {
                            int count = ProcessImplForWin32.countLeadingBackslash(verificationType, s, j);
                            while (count-- > 0) {
                                cmdbuf.append('\\');
                            }
                            cmdbuf.append('\\');
                        }
                        cmdbuf.append(c);
                    }
                } else {
                    cmdbuf.append(s);
                }
                int count = ProcessImplForWin32.countLeadingBackslash(verificationType, s, s.length());
                while (count-- > 0) {
                    cmdbuf.append('\\');
                }
                cmdbuf.append('\"');
                continue;
            }
            cmdbuf.append(s);
        }
        return cmdbuf.toString();
    }

    private static String unQuote(String str) {
        int len = str.length();
        return len >= 2 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"' ? str.substring(1, len - 1) : str;
    }

    private static boolean needsEscaping(int verificationType, String arg) {
        String unquotedArg = ProcessImplForWin32.unQuote(arg);
        boolean argIsQuoted = !arg.equals(unquotedArg);
        boolean embeddedQuote = unquotedArg.indexOf(34) >= 0;
        switch (verificationType) {
            case 0: {
                if (!embeddedQuote) break;
                throw new IllegalArgumentException("Argument has embedded quote, use the explicit CMD.EXE call.");
            }
            case 2: {
                if (!argIsQuoted || !embeddedQuote) break;
                throw new IllegalArgumentException("Malformed argument has embedded quote: " + unquotedArg);
            }
        }
        if (!argIsQuoted) {
            char[] testEscape = ESCAPE_VERIFICATION[verificationType];
            for (int i = 0; i < testEscape.length; ++i) {
                if (arg.indexOf(testEscape[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String path) throws IOException {
        String name = ProcessImplForWin32.unQuote(path);
        if (name.indexOf(34) >= 0) {
            throw new IllegalArgumentException("Executable name has embedded quote, split the arguments: " + name);
        }
        File fileToRun = new File(name);
        return fileToRun.getPath();
    }

    private boolean isExe(String executablePath) {
        File file = new File(executablePath);
        String upName = file.getName().toUpperCase(Locale.ROOT);
        return upName.endsWith(".EXE") || upName.indexOf(46) < 0;
    }

    private boolean isShellFile(String executablePath) {
        String upPath = executablePath.toUpperCase();
        return upPath.endsWith(".CMD") || upPath.endsWith(".BAT");
    }

    private String quoteString(String arg) {
        StringBuilder argbuf = new StringBuilder(arg.length() + 2);
        return argbuf.append('\"').append(arg).append('\"').toString();
    }

    private static int countLeadingBackslash(int verificationType, CharSequence input, int start) {
        int j;
        if (verificationType == 0) {
            return 0;
        }
        for (j = start - 1; j >= 0 && input.charAt(j) == '\\'; --j) {
        }
        return start - 1 - j;
    }

    private ProcessImplForWin32(String username, String password, String[] cmd, String envblock, String path, final long[] stdHandles, boolean redirectErrorStream) throws IOException {
        String cmdstr;
        boolean allowAmbiguousCommands;
        SecurityManager security = System.getSecurityManager();
        GetPropertyAction action = new GetPropertyAction("jdk.lang.Process.allowAmbiguousCommands", security == null ? "true" : "false");
        boolean bl = allowAmbiguousCommands = !"false".equalsIgnoreCase(action.run());
        if (allowAmbiguousCommands && security == null) {
            String executablePath = new File(cmd[0]).getPath();
            if (ProcessImplForWin32.needsEscaping(3, executablePath)) {
                executablePath = this.quoteString(executablePath);
            }
            cmdstr = ProcessImplForWin32.createCommandLine(3, executablePath, cmd);
        } else {
            boolean isShell;
            String executablePath;
            block6: {
                try {
                    executablePath = ProcessImplForWin32.getExecutablePath(cmd[0]);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder join = new StringBuilder();
                    for (String s : cmd) {
                        join.append(s).append(' ');
                    }
                    cmd = ProcessImplForWin32.getTokensFromCommand(join.toString());
                    executablePath = ProcessImplForWin32.getExecutablePath(cmd[0]);
                    if (security == null) break block6;
                    security.checkExec(executablePath);
                }
            }
            boolean bl2 = allowAmbiguousCommands ? this.isShellFile(executablePath) : (isShell = !this.isExe(executablePath));
            cmdstr = ProcessImplForWin32.createCommandLine(isShell ? 0 : (allowAmbiguousCommands ? 1 : 2), this.quoteString(executablePath), cmd);
        }
        this.handle = ProcessImplForWin32.create(username, password, cmdstr, envblock, path, stdHandles, redirectErrorStream);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (stdHandles[0] == -1L) {
                    ProcessImplForWin32.this.stdinStream = ProcessBuilderForWin32.NullOutputStream.INSTANCE;
                } else {
                    FileDescriptor stdinFd = new FileDescriptor();
                    ProcessImplForWin32.setHandle(stdinFd, stdHandles[0]);
                    ProcessImplForWin32.this.stdinStream = new BufferedOutputStream(new FileOutputStream(stdinFd));
                }
                if (stdHandles[1] == -1L) {
                    ProcessImplForWin32.this.stdoutStream = ProcessBuilderForWin32.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stdoutFd = new FileDescriptor();
                    ProcessImplForWin32.setHandle(stdoutFd, stdHandles[1]);
                    ProcessImplForWin32.this.stdoutStream = new BufferedInputStream(new FileInputStream(stdoutFd));
                }
                if (stdHandles[2] == -1L) {
                    ProcessImplForWin32.this.stderrStream = ProcessBuilderForWin32.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stderrFd = new FileDescriptor();
                    ProcessImplForWin32.setHandle(stderrFd, stdHandles[2]);
                    ProcessImplForWin32.this.stderrStream = new FileInputStream(stderrFd);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdinStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdoutStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderrStream;
    }

    protected void finalize() {
        ProcessImplForWin32.closeHandle(this.handle);
    }

    @Override
    public int exitValue() {
        int exitCode = ProcessImplForWin32.getExitCodeProcess(this.handle);
        if (exitCode == 259) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return exitCode;
    }

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImplForWin32.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (ProcessImplForWin32.getExitCodeProcess(this.handle) != 259) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long remainingNanos = unit.toNanos(timeout);
        long deadline = System.nanoTime() + remainingNanos;
        do {
            long msTimeout = TimeUnit.NANOSECONDS.toMillis(remainingNanos + 999999L);
            ProcessImplForWin32.waitForTimeoutInterruptibly(this.handle, msTimeout);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (ProcessImplForWin32.getExitCodeProcess(this.handle) == 259) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return ProcessImplForWin32.getExitCodeProcess(this.handle) != 259;
    }

    @Override
    public void destroy() {
        ProcessImplForWin32.terminateProcess(this.handle);
    }

    @Override
    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    @Override
    public boolean isAlive() {
        return ProcessImplForWin32.isProcessAlive(this.handle);
    }

    private static boolean initHolder(WinNT.HANDLEByReference pjhandles, WinNT.HANDLEByReference[] pipe, int offset, WinNT.HANDLEByReference phStd) {
        if (!pjhandles.getValue().equals((Object)JAVA_INVALID_HANDLE_VALUE)) {
            phStd.setValue(pjhandles.getValue());
            pjhandles.setValue(JAVA_INVALID_HANDLE_VALUE);
        } else {
            if (!Kernel32.INSTANCE.CreatePipe(pipe[0], pipe[1], null, 4120)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            WinNT.HANDLE thisProcessEnd = offset == 0 ? pipe[1].getValue() : pipe[0].getValue();
            phStd.setValue(pipe[offset].getValue());
            pjhandles.setValue(thisProcessEnd);
        }
        Kernel32.INSTANCE.SetHandleInformation(phStd.getValue(), 1, 1);
        return true;
    }

    private static void releaseHolder(boolean complete, WinNT.HANDLEByReference[] pipe, int offset) {
        ProcessImplForWin32.closeHandle(pipe[offset].getValue());
        if (complete) {
            ProcessImplForWin32.closeHandle(pipe[offset == 0 ? 1 : 0].getValue());
        }
    }

    private static void prepareIOEHandleState(WinNT.HANDLE[] stdIOE, Boolean[] inherit) {
        for (int i = 0; i < 6; ++i) {
            WinNT.HANDLE hstd = stdIOE[i];
            if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hstd)) continue;
            inherit[i] = Boolean.TRUE;
            Kernel32.INSTANCE.SetHandleInformation(hstd, 1, 0);
        }
    }

    private static void restoreIOEHandleState(WinNT.HANDLE[] stdIOE, Boolean[] inherit) {
        for (int i = 5; i >= 0; --i) {
            if (WinBase.INVALID_HANDLE_VALUE.equals((Object)stdIOE[i])) continue;
            Kernel32.INSTANCE.SetHandleInformation(stdIOE[i], 1, Boolean.TRUE.equals(inherit[i]) ? 1 : 0);
        }
    }

    private static WinNT.HANDLE processCreate(String username, String password, String cmd, String envblock, String path, WinNT.HANDLEByReference[] stdHandles, boolean redirectErrorStream) {
        WinNT.HANDLE ret = new WinNT.HANDLE(Pointer.createConstant((int)0));
        WinNT.HANDLE[] stdIOE = new WinNT.HANDLE[]{WinBase.INVALID_HANDLE_VALUE, WinBase.INVALID_HANDLE_VALUE, WinBase.INVALID_HANDLE_VALUE, stdHandles[0].getValue(), stdHandles[1].getValue(), stdHandles[2].getValue()};
        stdIOE[0] = Kernel32.INSTANCE.GetStdHandle(-10);
        stdIOE[1] = Kernel32.INSTANCE.GetStdHandle(-11);
        stdIOE[2] = Kernel32.INSTANCE.GetStdHandle(-12);
        Boolean[] inherit = new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
        ProcessImplForWin32.prepareIOEHandleState(stdIOE, inherit);
        WinNT.HANDLEByReference hStdInput = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference[] pipeIn = new WinNT.HANDLEByReference[]{new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE), new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE)};
        WinNT.HANDLEByReference hStdOutput = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference[] pipeOut = new WinNT.HANDLEByReference[]{new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE), new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE)};
        WinNT.HANDLEByReference hStdError = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference[] pipeError = new WinNT.HANDLEByReference[]{new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE), new WinNT.HANDLEByReference(WinBase.INVALID_HANDLE_VALUE)};
        if (ProcessImplForWin32.initHolder(stdHandles[0], pipeIn, 0, hStdInput)) {
            if (ProcessImplForWin32.initHolder(stdHandles[1], pipeOut, 1, hStdOutput)) {
                boolean success;
                WinBase.STARTUPINFO si = new WinBase.STARTUPINFO();
                si.hStdInput = hStdInput.getValue();
                si.hStdOutput = hStdOutput.getValue();
                if (redirectErrorStream) {
                    si.hStdError = si.hStdOutput;
                    stdHandles[2].setValue(JAVA_INVALID_HANDLE_VALUE);
                    success = true;
                } else {
                    success = ProcessImplForWin32.initHolder(stdHandles[2], pipeError, 1, hStdError);
                    si.hStdError = hStdError.getValue();
                }
                if (success) {
                    WTypes.LPSTR lpEnvironment = envblock == null ? new WTypes.LPSTR() : new WTypes.LPSTR(envblock);
                    WinBase.PROCESS_INFORMATION pi = new WinBase.PROCESS_INFORMATION();
                    si.dwFlags = 256;
                    if (!Advapi32.INSTANCE.CreateProcessWithLogonW(username, null, password, 1, null, cmd, 0x8000000, lpEnvironment.getPointer(), path, si, pi)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    ProcessImplForWin32.closeHandle(pi.hThread);
                    ret = pi.hProcess;
                }
                ProcessImplForWin32.releaseHolder(ret.getPointer().equals((Object)Pointer.createConstant((int)0)), pipeError, 1);
                ProcessImplForWin32.releaseHolder(ret.getPointer().equals((Object)Pointer.createConstant((int)0)), pipeOut, 1);
            }
            ProcessImplForWin32.releaseHolder(ret.getPointer().equals((Object)Pointer.createConstant((int)0)), pipeIn, 0);
        }
        ProcessImplForWin32.restoreIOEHandleState(stdIOE, inherit);
        return ret;
    }

    private static synchronized WinNT.HANDLE create(String username, String password, String cmd, String envblock, String path, long[] stdHandles, boolean redirectErrorStream) {
        int i;
        WinNT.HANDLE ret = new WinNT.HANDLE(Pointer.createConstant((int)0));
        WinNT.HANDLEByReference[] handles = new WinNT.HANDLEByReference[stdHandles.length];
        for (i = 0; i < stdHandles.length; ++i) {
            handles[i] = new WinNT.HANDLEByReference(new WinNT.HANDLE(Pointer.createConstant((long)stdHandles[i])));
        }
        if (cmd != null && username != null && password != null) {
            ret = ProcessImplForWin32.processCreate(username, password, cmd, envblock, path, handles, redirectErrorStream);
        }
        for (i = 0; i < stdHandles.length; ++i) {
            stdHandles[i] = handles[i].getPointer().getLong(0L);
        }
        return ret;
    }

    private static int getExitCodeProcess(WinNT.HANDLE handle) {
        IntByReference exitStatus = new IntByReference();
        if (!Kernel32.INSTANCE.GetExitCodeProcess(handle, exitStatus)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return exitStatus.getValue();
    }

    private static void terminateProcess(WinNT.HANDLE handle) {
        Kernel32.INSTANCE.TerminateProcess(handle, 1);
    }

    private static boolean isProcessAlive(WinNT.HANDLE handle) {
        IntByReference exitStatus = new IntByReference();
        Kernel32.INSTANCE.GetExitCodeProcess(handle, exitStatus);
        return exitStatus.getValue() == 259;
    }

    private static void closeHandle(WinNT.HANDLE handle) {
        if (!handle.equals((Object)WinBase.INVALID_HANDLE_VALUE)) {
            Kernel32Util.closeHandle((WinNT.HANDLE)handle);
        }
    }

    private static long openForAtomicAppend(String path) throws IOException {
        int access = -1073741824;
        int sharing = 3;
        int disposition = 4;
        int flagsAndAttributes = 128;
        if (path == null || path.isEmpty()) {
            return -1L;
        }
        WinNT.HANDLE handle = Kernel32.INSTANCE.CreateFile(path, access, sharing, null, disposition, flagsAndAttributes, null);
        if (handle == WinBase.INVALID_HANDLE_VALUE) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return handle.getPointer().getLong(0L);
    }

    private static void waitForInterruptibly(WinNT.HANDLE handle) {
        int result = Kernel32.INSTANCE.WaitForMultipleObjects(1, new WinNT.HANDLE[]{handle}, false, -1);
        if (result == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    private static void waitForTimeoutInterruptibly(WinNT.HANDLE handle, long timeout) {
        int result = Kernel32.INSTANCE.WaitForMultipleObjects(1, new WinNT.HANDLE[]{handle}, false, (int)timeout);
        if (result == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    static {
        if (!OSUtils.isWindows()) {
            throw new RuntimeException("ProcessImplForWin32 can be only initialized in Windows environment, but current OS is " + OSUtils.getOSName());
        }
        try {
            FD_HANDLE = Objects.requireNonNull(FileDescriptor.class.getDeclaredField("handle"));
            FD_HANDLE.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        JAVA_INVALID_HANDLE_VALUE = new WinNT.HANDLE(Pointer.createConstant((int)-1));
        ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t', '<', '>'}, {' ', '\t'}};
    }

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

