/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.alibaba.fastjson.JSON;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.PlaceholderUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.TimePlaceholderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParameterUtils.class);

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        if (StringUtils.isEmpty((String)parameterString) || parameterMap == null) {
            return parameterString;
        }
        String cronTimeStr = parameterMap.get("system.datetime");
        java.util.Date cronTime = null;
        if (StringUtils.isNotEmpty((String)cronTimeStr)) {
            try {
                cronTime = org.apache.commons.lang.time.DateUtils.parseDate((String)cronTimeStr, (String[])new String[]{"yyyyMMddHHmmss"});
            }
            catch (ParseException e) {
                logger.error("parse {} exception", (Object)cronTimeStr, (Object)e);
            }
        } else {
            cronTime = new java.util.Date();
        }
        parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        if (cronTime != null) {
            parameterString = TimePlaceholderUtils.replacePlaceholders(parameterString, cronTime, true);
        }
        return parameterString;
    }

    public static String convertParameterPlaceholders2(String parameterString, Map<String, String> parameterMap) {
        if (StringUtils.isEmpty((String)parameterString)) {
            return parameterString;
        }
        String cronTimeStr = parameterMap.get("schedule.time");
        java.util.Date cronTime = null;
        if (StringUtils.isNotEmpty((String)cronTimeStr)) {
            try {
                cronTime = org.apache.commons.lang.time.DateUtils.parseDate((String)cronTimeStr, (String[])new String[]{"yyyyMMddHHmmss"});
            }
            catch (ParseException e) {
                logger.error(String.format("parse %s exception", cronTimeStr), (Throwable)e);
            }
        } else {
            cronTime = new java.util.Date();
        }
        parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        if (cronTime != null) {
            parameterString = TimePlaceholderUtils.replacePlaceholders(parameterString, cronTime, true);
        }
        return parameterString;
    }

    public static void setInParameter(int index, PreparedStatement stmt, DataType dataType, String value) throws Exception {
        if (dataType.equals((Object)DataType.VARCHAR)) {
            stmt.setString(index, value);
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            stmt.setInt(index, Integer.parseInt(value));
        } else if (dataType.equals((Object)DataType.LONG)) {
            stmt.setLong(index, Long.parseLong(value));
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            stmt.setFloat(index, Float.parseFloat(value));
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            stmt.setDouble(index, Double.parseDouble(value));
        } else if (dataType.equals((Object)DataType.DATE)) {
            stmt.setDate(index, Date.valueOf(value));
        } else if (dataType.equals((Object)DataType.TIME)) {
            stmt.setString(index, value);
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            stmt.setTimestamp(index, Timestamp.valueOf(value));
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            stmt.setBoolean(index, Boolean.parseBoolean(value));
        }
    }

    public static String curingGlobalParams(Map<String, String> globalParamMap, List<Property> globalParamList, CommandType commandType, java.util.Date scheduleTime) {
        String val;
        if (globalParamList == null || globalParamList.isEmpty()) {
            return null;
        }
        HashMap<String, String> globalMap = new HashMap<String, String>();
        if (globalParamMap != null) {
            globalMap.putAll(globalParamMap);
        }
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        Map<String, String> timeParams = BusinessTimeUtils.getBusinessTime(commandType, scheduleTime);
        if (timeParams != null) {
            allParamMap.putAll(timeParams);
        }
        allParamMap.putAll(globalMap);
        Set entries = allParamMap.entrySet();
        HashMap resolveMap = new HashMap();
        for (Map.Entry entry : entries) {
            val = (String)entry.getValue();
            if (!val.startsWith("$")) continue;
            String str = ParameterUtils.convertParameterPlaceholders(val, allParamMap);
            resolveMap.put(entry.getKey(), str);
        }
        globalMap.putAll(resolveMap);
        for (Property property : globalParamList) {
            val = (String)globalMap.get(property.getProp());
            if (val == null) continue;
            property.setValue(val);
        }
        return JSON.toJSONString(globalParamList);
    }

    public static String handleEscapes(String inputString) {
        if (StringUtils.isNotEmpty((String)inputString)) {
            return inputString.replace("%", "////%");
        }
        return inputString;
    }

    public static String replaceScheduleTime(String text, java.util.Date scheduleTime) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (null == scheduleTime) {
            scheduleTime = new java.util.Date();
        }
        String dateTime = DateUtils.format(scheduleTime, "yyyyMMddHHmmss");
        Property p = new Property();
        p.setValue(dateTime);
        p.setProp("schedule.time");
        paramsMap.put("schedule.time", p);
        text = ParameterUtils.convertParameterPlaceholders2(text, ParameterUtils.convert(paramsMap));
        return text;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }
}

