/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;

public class ResInfo {
    private double cpuUsage;
    private double memoryUsage;
    private double loadAverage;

    public ResInfo() {
    }

    public ResInfo(double cpuUsage, double memoryUsage) {
        this.cpuUsage = cpuUsage;
        this.memoryUsage = memoryUsage;
    }

    public ResInfo(double cpuUsage, double memoryUsage, double loadAverage) {
        this(cpuUsage, memoryUsage);
        this.loadAverage = loadAverage;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public void setLoadAverage(double loadAverage) {
        this.loadAverage = loadAverage;
    }

    public static String getResInfoJson(double cpuUsage, double memoryUsage, double loadAverage) {
        ResInfo resInfo = new ResInfo(cpuUsage, memoryUsage, loadAverage);
        return JSONUtils.toJson(resInfo);
    }

    public static Server parseHeartbeatForZKInfo(String heartBeatInfo) {
        if (StringUtils.isEmpty(heartBeatInfo)) {
            return null;
        }
        String[] masterArray = heartBeatInfo.split(",");
        if (masterArray.length != 10) {
            return null;
        }
        Server masterServer = new Server();
        masterServer.setResInfo(ResInfo.getResInfoJson(Double.parseDouble(masterArray[0]), Double.parseDouble(masterArray[1]), Double.parseDouble(masterArray[2])));
        masterServer.setCreateTime(DateUtils.stringToDate(masterArray[6]));
        masterServer.setLastHeartbeatTime(DateUtils.stringToDate(masterArray[7]));
        masterServer.setId(Integer.parseInt(masterArray[9]));
        return masterServer;
    }
}

