/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;

public class TaskNode {
    private String id;
    private String name;
    private String desc;
    private String type;
    private String runFlag;
    private String loc;
    private int maxRetryTimes;
    private int retryInterval;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String params;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String preTasks;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String extras;
    private List<String> depList;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String dependence;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String conditionResult;
    private Priority taskInstancePriority;
    private String workerGroup;
    private Integer workerGroupId;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String timeout;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getPreTasks() {
        return this.preTasks;
    }

    public void setPreTasks(String preTasks) throws IOException {
        this.preTasks = preTasks;
        this.depList = JSONUtils.toList(preTasks, String.class);
    }

    public String getExtras() {
        return this.extras;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public List<String> getDepList() {
        return this.depList;
    }

    public void setDepList(List<String> depList) throws JsonProcessingException {
        this.depList = depList;
        this.preTasks = JSONUtils.toJson(depList);
    }

    public String getLoc() {
        return this.loc;
    }

    public void setLoc(String loc) {
        this.loc = loc;
    }

    public String getRunFlag() {
        return this.runFlag;
    }

    public void setRunFlag(String runFlag) {
        this.runFlag = runFlag;
    }

    public Boolean isForbidden() {
        return StringUtils.isNotEmpty(this.runFlag) && this.runFlag.equals("FORBIDDEN");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskNode taskNode = (TaskNode)o;
        return Objects.equals(this.name, taskNode.name) && Objects.equals(this.desc, taskNode.desc) && Objects.equals(this.type, taskNode.type) && Objects.equals(this.params, taskNode.params) && Objects.equals(this.preTasks, taskNode.preTasks) && Objects.equals(this.extras, taskNode.extras) && Objects.equals(this.runFlag, taskNode.runFlag) && Objects.equals(this.dependence, taskNode.dependence) && Objects.equals(this.workerGroup, taskNode.workerGroup) && Objects.equals(this.conditionResult, taskNode.conditionResult) && CollectionUtils.equalLists(this.depList, taskNode.depList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.desc, this.type, this.params, this.preTasks, this.extras, this.depList, this.runFlag);
    }

    public String getDependence() {
        return this.dependence;
    }

    public void setDependence(String dependence) {
        this.dependence = dependence;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public TaskTimeoutParameter getTaskTimeoutParameter() {
        if (StringUtils.isNotEmpty(this.getTimeout())) {
            String formatStr = String.format("%s,%s", TaskTimeoutStrategy.WARN.name(), TaskTimeoutStrategy.FAILED.name());
            String taskTimeout = this.getTimeout().replace(formatStr, TaskTimeoutStrategy.WARNFAILED.name());
            return (TaskTimeoutParameter)JSON.parseObject((String)taskTimeout, TaskTimeoutParameter.class);
        }
        return new TaskTimeoutParameter(false);
    }

    public boolean isConditionsTask() {
        return TaskType.CONDITIONS.toString().equalsIgnoreCase(this.getType());
    }

    public String toString() {
        return "TaskNode{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", type='" + this.type + '\'' + ", runFlag='" + this.runFlag + '\'' + ", loc='" + this.loc + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", params='" + this.params + '\'' + ", preTasks='" + this.preTasks + '\'' + ", extras='" + this.extras + '\'' + ", depList=" + this.depList + ", dependence='" + this.dependence + '\'' + ", taskInstancePriority=" + (Object)((Object)this.taskInstancePriority) + ", timeout='" + this.timeout + '\'' + ", workerGroup='" + this.workerGroup + '\'' + '}';
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public String getConditionResult() {
        return this.conditionResult;
    }

    public void setConditionResult(String conditionResult) {
        this.conditionResult = conditionResult;
    }

    public Integer getWorkerGroupId() {
        return this.workerGroupId;
    }

    public void setWorkerGroupId(Integer workerGroupId) {
        this.workerGroupId = workerGroupId;
    }
}

