/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.plugin.PluginClassLoader;
import org.apache.dolphinscheduler.common.plugin.PluginManager;
import org.apache.dolphinscheduler.plugin.api.AlertPlugin;
import org.apache.dolphinscheduler.plugin.spi.AlertPluginProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePluginManager
implements PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(FilePluginManager.class);
    private Map<String, AlertPlugin> pluginMap = new ConcurrentHashMap<String, AlertPlugin>();
    private Map<String, ServiceLoader<AlertPluginProvider>> pluginLoaderMap = new ConcurrentHashMap<String, ServiceLoader<AlertPluginProvider>>();
    private Map<String, PluginClassLoader> classLoaderMap = new ConcurrentHashMap<String, PluginClassLoader>();
    private String[] whitePrefixes;
    private String[] excludePrefixes;

    public FilePluginManager(String dirPath, String[] whitePrefixes, String[] excludePrefixes) {
        this.whitePrefixes = whitePrefixes;
        this.excludePrefixes = excludePrefixes;
        try {
            this.load(dirPath);
        }
        catch (MalformedURLException e) {
            logger.error("load plugins failed.", (Throwable)e);
        }
    }

    private void load(String dirPath) throws MalformedURLException {
        logger.info("start to load jar files in {}", (Object)dirPath);
        if (dirPath == null) {
            logger.error("not a valid path - {}", (Object)dirPath);
            return;
        }
        File[] files = new File(dirPath).listFiles();
        if (files == null) {
            logger.error("not a valid path - {}", (Object)dirPath);
            return;
        }
        for (File file : files) {
            if (file.isDirectory() && !file.getPath().endsWith(".jar")) continue;
            String pluginName = file.getName().substring(0, file.getName().length() - ".jar".length());
            URL[] urls = new URL[]{file.toURI().toURL()};
            PluginClassLoader classLoader = new PluginClassLoader(urls, Thread.currentThread().getContextClassLoader(), this.whitePrefixes, this.excludePrefixes);
            this.classLoaderMap.put(pluginName, classLoader);
            ServiceLoader<AlertPluginProvider> loader = ServiceLoader.load(AlertPluginProvider.class, classLoader);
            this.pluginLoaderMap.put(pluginName, loader);
            loader.forEach(provider -> {
                AlertPlugin plugin = provider.createPlugin();
                this.pluginMap.put(plugin.getId(), plugin);
                logger.info("loaded plugin - {}", (Object)plugin.getId());
            });
        }
    }

    @Override
    public AlertPlugin findOne(String name) {
        return this.pluginMap.get(name);
    }

    @Override
    public Map<String, AlertPlugin> findAll() {
        return this.pluginMap;
    }

    @Override
    public void addPlugin(AlertPlugin plugin) {
        this.pluginMap.put(plugin.getId(), plugin);
    }
}

