/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.plugin;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final String JAVA_PACKAGE_PREFIX = "java.";
    private static final String JAVAX_PACKAGE_PREFIX = "javax.";
    private final String[] whitePrefixes;
    private final String[] excludePrefixes;

    public PluginClassLoader(URL[] urls, ClassLoader parent, String[] whitePrefix, String[] excludePreifx) {
        super(urls, parent);
        this.whitePrefixes = whitePrefix;
        this.excludePrefixes = excludePreifx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        logger.trace("Received request to load class '{}'", (Object)name);
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (name.startsWith(JAVA_PACKAGE_PREFIX) || name.startsWith(JAVAX_PACKAGE_PREFIX)) {
                return this.findSystemClass(name);
            }
            boolean isWhitePrefixes = this.fromWhitePrefix(name);
            boolean isExcludePrefixed = this.fromExcludePrefix(name);
            if (!isWhitePrefixes && isExcludePrefixed) {
                return this.getParent().loadClass(name);
            }
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                logger.debug("Found loaded class '{}'", (Object)name);
                return loadedClass;
            }
            try {
                loadedClass = this.findClass(name);
                logger.debug("Found class '{}' in plugin classpath", (Object)name);
                return loadedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadClass(name);
            }
        }
    }

    private boolean fromWhitePrefix(String name) {
        if (this.whitePrefixes == null) {
            return false;
        }
        for (String whitePrefix : this.whitePrefixes) {
            if (!name.startsWith(whitePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean fromExcludePrefix(String name) {
        if (this.excludePrefixes == null) {
            return false;
        }
        for (String excludePrefix : this.excludePrefixes) {
            if (!name.startsWith(excludePrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> thisRes = this.findResources(name);
        if (thisRes != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = null;
        res = this.findResource(name);
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }
}

