/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.net.URL;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    private CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static String getSystemEnvPath() {
        String envPath = PropertyUtils.getString("dolphinscheduler.env.path");
        if (StringUtils.isEmpty(envPath)) {
            URL envDefaultPath = CommonUtils.class.getClassLoader().getResource("env/dolphinscheduler_env.sh");
            if (envDefaultPath != null) {
                envPath = envDefaultPath.getPath();
                logger.debug("env path :{}", (Object)envPath);
            } else {
                envPath = "/etc/profile";
            }
        }
        return envPath;
    }

    public static boolean isDevelopMode() {
        return PropertyUtils.getBoolean("development.state", true);
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getString("resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf(resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static void loadKerberosConf() throws Exception {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", PropertyUtils.getString("java.security.krb5.conf.path"));
            Configuration configuration = new Configuration();
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)PropertyUtils.getString("login.user.keytab.username"), (String)PropertyUtils.getString("login.user.keytab.path"));
        }
    }
}

