/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.placeholder;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.PropertyPlaceholderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePlaceholderUtils {
    private static final Logger logger = LoggerFactory.getLogger(TimePlaceholderUtils.class);
    public static final String PLACEHOLDER_PREFIX = "$[";
    public static final String PLACEHOLDER_SUFFIX = "]";

    public static String replacePlaceholders(String value, Date date, boolean ignoreUnresolvablePlaceholders) {
        PropertyPlaceholderHelper strictHelper = TimePlaceholderUtils.getPropertyPlaceholderHelper(false);
        PropertyPlaceholderHelper nonStrictHelper = TimePlaceholderUtils.getPropertyPlaceholderHelper(true);
        PropertyPlaceholderHelper helper = ignoreUnresolvablePlaceholders ? nonStrictHelper : strictHelper;
        return helper.replacePlaceholders(value, new TimePlaceholderResolver(value, date));
    }

    private static PropertyPlaceholderHelper getPropertyPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, null, ignoreUnresolvablePlaceholders);
    }

    public static Integer calculate(String expression) {
        expression = StringUtils.trim(expression);
        expression = TimePlaceholderUtils.convert(expression);
        List<String> result = TimePlaceholderUtils.string2List(expression);
        result = TimePlaceholderUtils.convert2SuffixList(result);
        return TimePlaceholderUtils.calculate(result);
    }

    private static String convert(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c;
            if (arr[i] == '-') {
                if (i == 0) {
                    arr[i] = 78;
                    continue;
                }
                c = arr[i - 1];
                if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(') continue;
                arr[i] = 78;
                continue;
            }
            if (arr[i] != '+') continue;
            if (i == 0) {
                arr[i] = 80;
                continue;
            }
            c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(') continue;
            arr[i] = 80;
        }
        return new String(arr);
    }

    private static List<String> convert2SuffixList(List<String> srcList) {
        ArrayList<String> result = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        block4: for (int i = 0; i < srcList.size(); ++i) {
            if (Character.isDigit(srcList.get(i).charAt(0))) {
                result.add(srcList.get(i));
                continue;
            }
            switch (srcList.get(i).charAt(0)) {
                case '(': {
                    stack.push(srcList.get(i));
                    continue block4;
                }
                case ')': {
                    while (!"(".equals(stack.peek())) {
                        result.add((String)stack.pop());
                    }
                    stack.pop();
                    continue block4;
                }
                default: {
                    while (!stack.isEmpty() && TimePlaceholderUtils.compare((String)stack.peek(), srcList.get(i))) {
                        result.add((String)stack.pop());
                    }
                    stack.push(srcList.get(i));
                }
            }
        }
        while (!stack.isEmpty()) {
            result.add((String)stack.pop());
        }
        return result;
    }

    private static Integer calculate(List<String> result) {
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < result.size(); ++i) {
            if (Character.isDigit(result.get(i).charAt(0))) {
                stack.push(Integer.parseInt(result.get(i)));
                continue;
            }
            Integer backInt = (Integer)stack.pop();
            Integer frontInt = 0;
            char op = result.get(i).charAt(0);
            if (op != 'P' && op != 'N') {
                frontInt = (Integer)stack.pop();
            }
            Integer res = 0;
            switch (result.get(i).charAt(0)) {
                case 'P': {
                    res = frontInt + backInt;
                    break;
                }
                case 'N': {
                    res = frontInt - backInt;
                    break;
                }
                case '+': {
                    res = frontInt + backInt;
                    break;
                }
                case '-': {
                    res = frontInt - backInt;
                    break;
                }
                case '*': {
                    res = frontInt * backInt;
                    break;
                }
                case '/': {
                    res = frontInt / backInt;
                    break;
                }
            }
            stack.push(res);
        }
        return (Integer)stack.pop();
    }

    private static List<String> string2List(String expression) {
        ArrayList<String> result = new ArrayList<String>();
        String num = "";
        for (int i = 0; i < expression.length(); ++i) {
            if (Character.isDigit(expression.charAt(i))) {
                num = num + expression.charAt(i);
                continue;
            }
            if (!num.isEmpty()) {
                result.add(num);
            }
            result.add(expression.charAt(i) + "");
            num = "";
        }
        if (!num.isEmpty()) {
            result.add(num);
        }
        return result;
    }

    private static boolean compare(String peek, String cur) {
        if ("*".equals(peek) && ("/".equals(cur) || "*".equals(cur) || "+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        if ("/".equals(peek) && ("/".equals(cur) || "*".equals(cur) || "+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        if ("+".equals(peek) && ("+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        return "-".equals(peek) && ("+".equals(cur) || "-".equals(cur));
    }

    public static String getPlaceHolderTime(String expression, Date date) {
        if (StringUtils.isBlank(expression)) {
            return null;
        }
        if (null == date) {
            return null;
        }
        return TimePlaceholderUtils.calculateTime(expression, date);
    }

    private static String calculateTime(String expression, Date date) {
        String value;
        try {
            if (expression.startsWith("timestamp")) {
                String timeExpression = expression.substring("timestamp".length() + 1, expression.length() - 1);
                Map.Entry<Date, String> entry = TimePlaceholderUtils.calcTimeExpression(timeExpression, date);
                String dateStr = DateUtils.format(entry.getKey(), entry.getValue());
                Date timestamp = DateUtils.parse(dateStr, "yyyyMMddHHmmss");
                value = String.valueOf(timestamp.getTime() / 1000L);
            } else {
                Map.Entry<Date, String> entry = TimePlaceholderUtils.calcTimeExpression(expression, date);
                value = DateUtils.format(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return value;
    }

    public static Map.Entry<Date, String> calcTimeExpression(String expression, Date date) {
        Map.Entry<Date, String> resultEntry = expression.startsWith("add_months") ? TimePlaceholderUtils.calcMonths(expression, date) : (expression.startsWith("month_begin") ? TimePlaceholderUtils.calcMonthBegin(expression, date) : (expression.startsWith("month_end") ? TimePlaceholderUtils.calcMonthEnd(expression, date) : (expression.startsWith("week_begin") ? TimePlaceholderUtils.calcWeekStart(expression, date) : (expression.startsWith("week_end") ? TimePlaceholderUtils.calcWeekEnd(expression, date) : TimePlaceholderUtils.calcMinutes(expression, date)))));
        return resultEntry;
    }

    public static Map.Entry<Date, String> calcMonthBegin(String expression, Date date) {
        String addMonthExpr = expression.substring("month_begin".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = DateUtils.getFirstDayOfMonth(date);
            targetDate = org.apache.commons.lang.time.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcMonthEnd(String expression, Date date) {
        String addMonthExpr = expression.substring("month_end".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = DateUtils.getLastDayOfMonth(date);
            targetDate = org.apache.commons.lang.time.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcWeekStart(String expression, Date date) {
        String addMonthExpr = expression.substring("week_begin".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = DateUtils.getMonday(date);
            targetDate = org.apache.commons.lang.time.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcWeekEnd(String expression, Date date) {
        String addMonthExpr = expression.substring("week_end".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = DateUtils.getSunday(date);
            targetDate = org.apache.commons.lang.time.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("Expression not valid");
    }

    public static Map.Entry<Date, String> calcMonths(String expression, Date date) {
        String addMonthExpr = expression.substring("add_months".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String monthExpr = params[1];
            Integer addMonth = TimePlaceholderUtils.calculate(monthExpr);
            Date targetDate = org.apache.commons.lang.time.DateUtils.addMonths((Date)date, (int)addMonth);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcMinutes(String expression, Date date) {
        if (expression.contains("+")) {
            int index = expression.lastIndexOf(43);
            if (Character.isDigit(expression.charAt(index + 1))) {
                String addMinuteExpr = expression.substring(index + 1);
                Date targetDate = org.apache.commons.lang.time.DateUtils.addMinutes((Date)date, (int)TimePlaceholderUtils.calcMinutes(addMinuteExpr));
                String dateFormat = expression.substring(0, index);
                return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
            }
        } else if (expression.contains("-")) {
            int index = expression.lastIndexOf(45);
            if (Character.isDigit(expression.charAt(index + 1))) {
                String addMinuteExpr = expression.substring(index + 1);
                Date targetDate = org.apache.commons.lang.time.DateUtils.addMinutes((Date)date, (int)(0 - TimePlaceholderUtils.calcMinutes(addMinuteExpr)));
                String dateFormat = expression.substring(0, index);
                return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
            }
            return new AbstractMap.SimpleImmutableEntry<Date, String>(date, expression);
        }
        return new AbstractMap.SimpleImmutableEntry<Date, String>(date, expression);
    }

    public static Integer calcMinutes(String minuteExpression) {
        int index = minuteExpression.indexOf(47);
        String calcExpression = index == -1 ? String.format("60*24*(%s)", minuteExpression) : String.format("60*24*(%s)%s", minuteExpression.substring(0, index), minuteExpression.substring(index));
        return TimePlaceholderUtils.calculate(calcExpression);
    }

    private static class TimePlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String value;
        private final Date date;

        public TimePlaceholderResolver(String value, Date date) {
            this.value = value;
            this.date = date;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            try {
                return TimePlaceholderUtils.calculateTime(placeholderName, this.date);
            }
            catch (Exception ex) {
                logger.error("resolve placeholder '{}' in [ {} ]", new Object[]{placeholderName, this.value, ex});
                return null;
            }
        }
    }
}

