/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    private static final Base64 BASE64 = new Base64();

    private CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static String getSystemEnvPath() {
        String envPath = PropertyUtils.getString("dolphinscheduler.env.path");
        if (StringUtils.isEmpty((String)envPath)) {
            URL envDefaultPath = CommonUtils.class.getClassLoader().getResource("env/dolphinscheduler_env.sh");
            if (envDefaultPath != null) {
                envPath = envDefaultPath.getPath();
                logger.debug("env path :{}", (Object)envPath);
            } else {
                envPath = "/etc/profile";
            }
        }
        return envPath;
    }

    public static boolean isDevelopMode() {
        return PropertyUtils.getBoolean("development.state", true);
    }

    public static boolean isSudoEnable() {
        return PropertyUtils.getBoolean("sudo.enable", true);
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString("resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf(resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static boolean loadKerberosConf(Configuration configuration) throws IOException {
        return CommonUtils.loadKerberosConf(PropertyUtils.getString("java.security.krb5.conf.path"), PropertyUtils.getString("login.user.keytab.username"), PropertyUtils.getString("login.user.keytab.path"), configuration);
    }

    public static void loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath) throws IOException {
        CommonUtils.loadKerberosConf(javaSecurityKrb5Conf, loginUserKeytabUsername, loginUserKeytabPath, new Configuration());
    }

    public static boolean loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath, Configuration configuration) throws IOException {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", StringUtils.defaultIfBlank((String)javaSecurityKrb5Conf, (String)PropertyUtils.getString("java.security.krb5.conf.path")));
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)StringUtils.defaultIfBlank((String)loginUserKeytabUsername, (String)PropertyUtils.getString("login.user.keytab.username")), (String)StringUtils.defaultIfBlank((String)loginUserKeytabPath, (String)PropertyUtils.getString("login.user.keytab.path")));
            return true;
        }
        return false;
    }

    public static String encodePassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean("datasource.encryption.enable", false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString("datasource.encryption.salt", "!@#$%^&*");
        String passwordWithSalt = salt + new String(BASE64.encode(password.getBytes(StandardCharsets.UTF_8)));
        return new String(BASE64.encode(passwordWithSalt.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decodePassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean("datasource.encryption.enable", false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString("datasource.encryption.salt", "!@#$%^&*");
        String passwordWithSalt = new String(BASE64.decode(password), StandardCharsets.UTF_8);
        if (!passwordWithSalt.startsWith(salt)) {
            logger.warn("There is a password and salt mismatch: {} ", (Object)password);
            return password;
        }
        return new String(BASE64.decode(passwordWithSalt.substring(salt.length())), StandardCharsets.UTF_8);
    }
}

