/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");
    public static final ThreadLocal<Logger> taskLoggerThreadLocal = new ThreadLocal();

    private FileUtils() {
        throw new UnsupportedOperationException("Construct FileUtils");
    }

    public static String suffix(String filename) {
        int lastIndex;
        String fileSuffix = "";
        if (!StringUtils.isEmpty((String)filename) && (lastIndex = filename.lastIndexOf(46)) > 0) {
            fileSuffix = filename.substring(lastIndex + 1);
        }
        return fileSuffix;
    }

    public static String getDownloadFilename(String filename) {
        String fileName = String.format("%s/download/%s/%s", DATA_BASEDIR, DateUtils.getCurrentTime("yyyyMMddHHmmss"), filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getUploadFilename(String tenantCode, String filename) {
        String fileName = String.format("%s/%s/resources/%s", DATA_BASEDIR, tenantCode, filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getProcessExecDir(long projectCode, long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        String fileName = String.format("%s/exec/process/%d/%s/%d/%d", DATA_BASEDIR, projectCode, processDefineCode + "_" + processDefineVersion, processInstanceId, taskInstanceId);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getResourceViewSuffixs() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js");
    }

    public static void createWorkDirIfAbsent(String execLocalPath) throws IOException {
        File execLocalPathFile = new File(execLocalPath);
        if (execLocalPathFile.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)execLocalPathFile);
        }
        org.apache.commons.io.FileUtils.forceMkdir((File)execLocalPathFile);
        String mkdirLog = "create dir success " + execLocalPath;
        LoggerUtils.logInfo(Optional.ofNullable(logger), mkdirLog);
        LoggerUtils.logInfo(Optional.ofNullable(taskLoggerThreadLocal.get()), mkdirLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeContent2File(String content, String filePath) {
        BufferedWriter bufferedWriter;
        BufferedReader bufferedReader;
        block9: {
            boolean bl;
            block8: {
                bufferedReader = null;
                bufferedWriter = null;
                try {
                    int len;
                    File distFile = new File(filePath);
                    if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                        logger.error("mkdir parent failed");
                        bl = false;
                        IOUtils.closeQuietly(bufferedWriter);
                        break block8;
                    }
                    bufferedReader = new BufferedReader(new StringReader(content));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(distFile), StandardCharsets.UTF_8));
                    char[] buf = new char[1024];
                    while ((len = bufferedReader.read(buf)) != -1) {
                        bufferedWriter.write(buf, 0, len);
                    }
                    bufferedWriter.flush();
                    bufferedReader.close();
                    bufferedWriter.close();
                    IOUtils.closeQuietly((Writer)bufferedWriter);
                    break block9;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
            return bl;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return true;
        finally {
            IOUtils.closeQuietly(bufferedWriter);
            IOUtils.closeQuietly(bufferedReader);
        }
    }

    public static void deleteFile(String filename) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
    }

    public static File[] getAllDir(String parentDir) {
        if (parentDir == null || "".equals(parentDir)) {
            throw new RuntimeException("parentDir can not be empty");
        }
        File file = new File(parentDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("parentDir not exist, or is not a directory:" + parentDir);
        }
        return file.listFiles(File::isDirectory);
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

