/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");
    public static final String TASK_LOGGER_INFO_PREFIX = "TASK";
    public static final String TASK_LOGGER_THREAD_NAME = "TaskLogInfo";
    public static final String TASK_APPID_LOG_FORMAT = "[taskAppId=";

    private LoggerUtils() {
        throw new UnsupportedOperationException("Construct LoggerUtils");
    }

    public static String buildTaskId(String affix, Long processDefineCode, int processDefineVersion, int processInstId, int taskId) {
        return String.format(" - %s%s-%s_%s-%s-%s]", TASK_APPID_LOG_FORMAT, affix, processDefineCode, processDefineVersion, processInstId, taskId);
    }

    public static List<String> getAppIds(String log, Logger logger) {
        ArrayList<String> appIds = new ArrayList<String>();
        Matcher matcher = APPLICATION_REGEX.matcher(log);
        while (matcher.find()) {
            String appId = matcher.group();
            if (appIds.contains(appId)) continue;
            logger.info("find app id: {}", (Object)appId);
            appIds.add(appId);
        }
        return appIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWholeFileContent(String filePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file error", (Throwable)e);
            return "";
        }
    }

    public static void logError(Optional<Logger> optionalLogger, String error) {
        optionalLogger.ifPresent(logger -> logger.error(error));
    }

    public static void logError(Optional<Logger> optionalLogger, Throwable e) {
        optionalLogger.ifPresent(logger -> logger.error(e.getMessage(), e));
    }

    public static void logError(Optional<Logger> optionalLogger, String error, Throwable e) {
        optionalLogger.ifPresent(logger -> logger.error(error, e));
    }

    public static void logInfo(Optional<Logger> optionalLogger, String info) {
        optionalLogger.ifPresent(logger -> logger.info(info));
    }
}

