/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class SnowFlakeUtils {
    private static final long START_TIMESTAMP = 1609430400000L;
    private static final long SEQUENCE_BIT = 13L;
    private static final long MACHINE_BIT = 2L;
    private static final long MAX_SEQUENCE = 8191L;
    private static final long MACHINE_LEFT = 13L;
    private static final long TIMESTAMP_LEFT = 15L;
    private final int machineId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static SnowFlakeUtils instance = null;

    private SnowFlakeUtils() throws SnowFlakeException {
        try {
            this.machineId = Math.abs(Objects.hash(InetAddress.getLocalHost().getHostName())) % 32;
        }
        catch (UnknownHostException e) {
            throw new SnowFlakeException(e.getMessage());
        }
    }

    public static synchronized SnowFlakeUtils getInstance() throws SnowFlakeException {
        if (instance == null) {
            instance = new SnowFlakeUtils();
        }
        return instance;
    }

    public synchronized long nextId() throws SnowFlakeException {
        long currStmp = this.nowTimestamp();
        if (currStmp < this.lastTimestamp) {
            throw new SnowFlakeException("Clock moved backwards. Refusing to generate id");
        }
        if (currStmp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0x1FFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currStmp;
        return currStmp - 1609430400000L << 15 | (long)(this.machineId << 13) | this.sequence;
    }

    private long getNextMill() {
        long mill = this.nowTimestamp();
        while (mill <= this.lastTimestamp) {
            mill = this.nowTimestamp();
        }
        return mill;
    }

    private long nowTimestamp() {
        return System.currentTimeMillis();
    }

    public static class SnowFlakeException
    extends Exception {
        public SnowFlakeException(String message) {
            super(message);
        }
    }
}

