/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");

    private FileUtils() {
        throw new UnsupportedOperationException("Construct FileUtils");
    }

    public static String getDownloadFilename(String filename) {
        String fileName = String.format("%s/download/%s/%s", DATA_BASEDIR, DateUtils.getCurrentTime("yyyyMMddHHmmss"), filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getUploadFilename(String tenantCode, String filename) {
        String fileName = String.format("%s/%s/resources/%s", DATA_BASEDIR, tenantCode, filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getProcessExecDir(long projectCode, long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        String fileName = String.format("%s/exec/process/%d/%s/%d/%d", DATA_BASEDIR, projectCode, processDefineCode + "_" + processDefineVersion, processInstanceId, taskInstanceId);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getResourceViewSuffixs() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js");
    }

    public static void createWorkDirIfAbsent(String execLocalPath) throws IOException {
        File execLocalPathFile = new File(execLocalPath);
        if (execLocalPathFile.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)execLocalPathFile);
        }
        org.apache.commons.io.FileUtils.forceMkdir((File)execLocalPathFile);
        String mkdirLog = "create dir success " + execLocalPath;
        logger.info(mkdirLog);
    }

    public static boolean writeContent2File(String content, String filePath) {
        try {
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                logger.error("mkdir parent failed");
                return false;
            }
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(filePath), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static void deleteFile(String filename) {
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(filename));
    }

    public static File[] getAllDir(String parentDir) {
        if (parentDir == null || "".equals(parentDir)) {
            throw new RuntimeException("parentDir can not be empty");
        }
        File file = new File(parentDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("parentDir not exist, or is not a directory:" + parentDir);
        }
        return file.listFiles(File::isDirectory);
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

