/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadLocalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private DateUtils() {
        throw new UnsupportedOperationException("Construct DateUtils");
    }

    private static LocalDateTime date2LocalDateTime(Date date) {
        String timezone = ThreadLocalContext.getTimezoneThreadLocal().get();
        ZoneId zoneId = StringUtils.isNotEmpty((String)timezone) ? ZoneId.of(timezone) : ZoneId.systemDefault();
        return DateUtils.date2LocalDateTime(date, zoneId);
    }

    private static LocalDateTime date2LocalDateTime(Date date, ZoneId zoneId) {
        return LocalDateTime.ofInstant(date.toInstant(), zoneId);
    }

    private static Date localDateTime2Date(LocalDateTime localDateTime) {
        String timezone = ThreadLocalContext.getTimezoneThreadLocal().get();
        ZoneId zoneId = StringUtils.isNotEmpty((String)timezone) ? ZoneId.of(timezone) : ZoneId.systemDefault();
        return DateUtils.localDateTime2Date(localDateTime, zoneId);
    }

    private static Date localDateTime2Date(LocalDateTime localDateTime, ZoneId zoneId) {
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return Date.from(instant);
    }

    public static String getCurrentTime(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String format(Date date, String format, String timezone) {
        return DateUtils.format(date, DateTimeFormatter.ofPattern(format), timezone);
    }

    public static String format(Date date, DateTimeFormatter dateTimeFormatter, String timezone) {
        LocalDateTime localDateTime = StringUtils.isEmpty((String)timezone) ? DateUtils.date2LocalDateTime(date) : DateUtils.date2LocalDateTime(date, ZoneId.of(timezone));
        return DateUtils.format(localDateTime, dateTimeFormatter);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return DateUtils.format(localDateTime, DateTimeFormatter.ofPattern(format));
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return localDateTime.format(dateTimeFormatter);
    }

    public static String dateToString(Date date) {
        return DateUtils.format(date, YYYY_MM_DD_HH_MM_SS, null);
    }

    public static String dateToString(Date date, String timezone) {
        return DateUtils.format(date, YYYY_MM_DD_HH_MM_SS, timezone);
    }

    public static Date parse(String date, String format, String timezone) {
        return DateUtils.parse(date, DateTimeFormatter.ofPattern(format), timezone);
    }

    public static Date parse(String date, DateTimeFormatter dateTimeFormatter, String timezone) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(date, dateTimeFormatter);
            if (StringUtils.isEmpty((String)timezone)) {
                return DateUtils.localDateTime2Date(ldt);
            }
            return DateUtils.localDateTime2Date(ldt, ZoneId.of(timezone));
        }
        catch (Exception e) {
            logger.error("error while parse date:" + date, (Throwable)e);
            return null;
        }
    }

    public static Date stringToDate(String date) {
        return DateUtils.parse(date, YYYY_MM_DD_HH_MM_SS, null);
    }

    public static Date stringToDate(String date, String timezone) {
        return DateUtils.parse(date, YYYY_MM_DD_HH_MM_SS, timezone);
    }

    public static long differSec(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return 0L;
        }
        return (long)Math.ceil((double)DateUtils.differMs(d1, d2) / 1000.0);
    }

    public static long differMs(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime());
    }

    public static Date getSomeDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static int getHourIndex(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static boolean compare(Date future, Date old) {
        return future.getTime() > old.getTime();
    }

    public static Date getScheduleDate(String schedule) {
        return DateUtils.stringToDate(schedule);
    }

    public static String format2Readable(long ms) {
        long days = MILLISECONDS.toDays(ms);
        long hours = MILLISECONDS.toDurationHours(ms);
        long minutes = MILLISECONDS.toDurationMinutes(ms);
        long seconds = MILLISECONDS.toDurationSeconds(ms);
        return String.format("%02d %02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static String format2Duration(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return DateUtils.format2Duration(DateUtils.differMs(d1, d2));
    }

    public static String format2Duration(long ms) {
        long days = MILLISECONDS.toDays(ms);
        long hours = MILLISECONDS.toDurationHours(ms);
        long minutes = MILLISECONDS.toDurationMinutes(ms);
        long seconds = MILLISECONDS.toDurationSeconds(ms);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder = days > 0L ? strBuilder.append(days).append("d").append(" ") : strBuilder;
        strBuilder = hours > 0L ? strBuilder.append(hours).append("h").append(" ") : strBuilder;
        strBuilder = minutes > 0L ? strBuilder.append(minutes).append("m").append(" ") : strBuilder;
        strBuilder = seconds > 0L ? strBuilder.append(seconds).append("s") : strBuilder;
        return strBuilder.toString();
    }

    public static Date getMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 1);
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getSomeHourOfDay(Date date, int offsetHour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, cal.get(11) + offsetHour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfDay(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getStartOfHour(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfHour(Date inputDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inputDay);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static long getRemainTime(Date baseTime, long intervalSeconds) {
        if (baseTime == null) {
            return 0L;
        }
        long usedTime = (System.currentTimeMillis() - baseTime.getTime()) / 1000L;
        return intervalSeconds - usedTime;
    }

    public static String getCurrentTimeStamp() {
        return DateUtils.getCurrentTime("yyyyMMddHHmmssSSS");
    }

    public static Date getTimezoneDate(Date date, String targetTimezoneId) {
        if (StringUtils.isEmpty((String)targetTimezoneId)) {
            return date;
        }
        String dateToString = DateUtils.dateToString(date);
        LocalDateTime localDateTime = LocalDateTime.parse(dateToString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, TimeZone.getTimeZone(targetTimezoneId).toZoneId());
        return Date.from(zonedDateTime.toInstant());
    }

    public static TimeZone getTimezone(String timezoneId) {
        if (StringUtils.isEmpty((String)timezoneId)) {
            return null;
        }
        return TimeZone.getTimeZone(timezoneId);
    }

    public static class MILLISECONDS {
        public static long toDays(long d) {
            return d / 86400000L;
        }

        public static long toDurationSeconds(long d) {
            return d % 60000L / 1000L;
        }

        public static long toDurationMinutes(long d) {
            return d % 3600000L / 60000L;
        }

        public static long toDurationHours(long d) {
            return d % 86400000L / 3600000L;
        }
    }
}

