/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.exception.BaseException;
import org.apache.dolphinscheduler.common.storage.StorageOperate;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HttpUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.KerberosHttpClient;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.cli.RMAdminCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils
implements Closeable,
StorageOperate {
    private static final Logger logger = LoggerFactory.getLogger(HadoopUtils.class);
    private String hdfsUser = PropertyUtils.getString("hdfs.root.user");
    public static final String RM_HA_IDS = PropertyUtils.getString("yarn.resourcemanager.ha.rm.ids");
    public static final String APP_ADDRESS = PropertyUtils.getString("yarn.application.status.address");
    public static final String JOB_HISTORY_ADDRESS = PropertyUtils.getString("yarn.job.history.status.address");
    public static final int HADOOP_RESOURCE_MANAGER_HTTP_ADDRESS_PORT_VALUE = PropertyUtils.getInt("resource.manager.httpaddress.port", 8088);
    private static final String HADOOP_UTILS_KEY = "HADOOP_UTILS_KEY";
    private static final LoadingCache<String, HadoopUtils> cache = CacheBuilder.newBuilder().expireAfterWrite((long)PropertyUtils.getInt("kerberos.expire.time", 2), TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, HadoopUtils>(){

        public HadoopUtils load(String key) throws Exception {
            return new HadoopUtils();
        }
    });
    private volatile boolean yarnEnabled = false;
    private Configuration configuration;
    private FileSystem fs;

    private HadoopUtils() {
        this.init();
        this.initHdfsPath();
    }

    public static HadoopUtils getInstance() {
        return (HadoopUtils)cache.getUnchecked((Object)HADOOP_UTILS_KEY);
    }

    private void initHdfsPath() {
        Path path = new Path(RESOURCE_UPLOAD_PATH);
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() throws NullPointerException {
        try {
            String defaultFS;
            this.configuration = new HdfsConfiguration();
            if (CommonUtils.loadKerberosConf(this.configuration)) {
                this.hdfsUser = "";
            }
            if ((defaultFS = this.configuration.get("fs.defaultFS")).startsWith("file")) {
                String defaultFSProp = PropertyUtils.getString("fs.defaultFS");
                if (!StringUtils.isNotBlank((String)defaultFSProp)) {
                    logger.error("property:{} can not to be empty, please set!", (Object)"fs.defaultFS");
                    throw new NullPointerException(String.format("property: %s can not to be empty, please set!", "fs.defaultFS"));
                }
                Map<String, String> fsRelatedProps = PropertyUtils.getPrefixedProperties("fs.");
                this.configuration.set("fs.defaultFS", defaultFSProp);
                fsRelatedProps.forEach((key, value) -> this.configuration.set(key, value));
            } else {
                logger.info("get property:{} -> {}, from core-site.xml hdfs-site.xml ", (Object)"fs.defaultFS", (Object)defaultFS);
            }
            if (StringUtils.isNotEmpty((String)this.hdfsUser)) {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.hdfsUser);
                ugi.doAs(() -> {
                    this.fs = FileSystem.get((Configuration)this.configuration);
                    return true;
                });
                return;
            }
            logger.warn("hdfs.root.user is not set value!");
            this.fs = FileSystem.get((Configuration)this.configuration);
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDefaultFS() {
        return this.getConfiguration().get("fs.defaultFS");
    }

    public String getApplicationUrl(String applicationId) throws BaseException {
        String appUrl;
        this.yarnEnabled = true;
        String string = appUrl = StringUtils.isEmpty((String)RM_HA_IDS) ? APP_ADDRESS : HadoopUtils.getAppAddress(APP_ADDRESS, RM_HA_IDS);
        if (StringUtils.isBlank((String)appUrl)) {
            throw new BaseException("yarn application url generation failed");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("yarn application url:{}, applicationId:{}", (Object)appUrl, (Object)applicationId);
        }
        return String.format(appUrl, HADOOP_RESOURCE_MANAGER_HTTP_ADDRESS_PORT_VALUE, applicationId);
    }

    public String getJobHistoryUrl(String applicationId) {
        String jobId = applicationId.replace("application", "job");
        return String.format(JOB_HISTORY_ADDRESS, jobId);
    }

    public byte[] catFile(String hdfsFilePath) throws IOException {
        if (StringUtils.isBlank((String)hdfsFilePath)) {
            logger.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return new byte[0];
        }
        try (FSDataInputStream fsDataInputStream = this.fs.open(new Path(hdfsFilePath));){
            byte[] byArray = IOUtils.toByteArray((InputStream)fsDataInputStream);
            return byArray;
        }
    }

    public List<String> catFile(String hdfsFilePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((String)hdfsFilePath)) {
            logger.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return Collections.emptyList();
        }
        try (FSDataInputStream in = this.fs.open(new Path(hdfsFilePath));){
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            Stream<String> stream = br.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> vimFile(String bucketName, String hdfsFilePath, int skipLineNums, int limit) throws IOException {
        return this.catFile(hdfsFilePath, skipLineNums, limit);
    }

    @Override
    public void createTenantDirIfNotExists(String tenantCode) throws IOException {
        HadoopUtils.getInstance().mkdir(tenantCode, HadoopUtils.getHdfsResDir(tenantCode));
        HadoopUtils.getInstance().mkdir(tenantCode, HadoopUtils.getHdfsUdfDir(tenantCode));
    }

    @Override
    public String getResDir(String tenantCode) {
        return HadoopUtils.getHdfsResDir(tenantCode);
    }

    @Override
    public String getUdfDir(String tenantCode) {
        return HadoopUtils.getHdfsUdfDir(tenantCode);
    }

    @Override
    public boolean mkdir(String bucketName, String hdfsPath) throws IOException {
        return this.fs.mkdirs(new Path(hdfsPath));
    }

    @Override
    public String getResourceFileName(String tenantCode, String fullName) {
        return HadoopUtils.getHdfsResourceFileName(tenantCode, fullName);
    }

    @Override
    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        return HadoopUtils.getHdfsFileName(resourceType, tenantCode, fileName);
    }

    @Override
    public void download(String bucketName, String srcHdfsFilePath, String dstFile, boolean deleteSource, boolean overwrite) throws IOException {
        this.copyHdfsToLocal(srcHdfsFilePath, dstFile, deleteSource, overwrite);
    }

    @Override
    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        return FileUtil.copy((FileSystem)this.fs, (Path)new Path(srcPath), (FileSystem)this.fs, (Path)new Path(dstPath), (boolean)deleteSource, (boolean)overwrite, (Configuration)this.fs.getConf());
    }

    public boolean copyLocalToHdfs(String srcFile, String dstHdfsPath, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcFile);
        Path dstPath = new Path(dstHdfsPath);
        this.fs.copyFromLocalFile(deleteSource, overwrite, srcPath, dstPath);
        return true;
    }

    @Override
    public boolean upload(String buckName, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        return this.copyLocalToHdfs(srcFile, dstPath, deleteSource, overwrite);
    }

    public boolean copyHdfsToLocal(String srcHdfsFilePath, String dstFile, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcHdfsFilePath);
        File dstPath = new File(dstFile);
        if (dstPath.exists()) {
            if (dstPath.isFile()) {
                if (overwrite) {
                    Files.delete(dstPath.toPath());
                }
            } else {
                logger.error("destination file must be a file");
            }
        }
        if (!dstPath.getParentFile().exists() && !dstPath.getParentFile().mkdirs()) {
            return false;
        }
        return FileUtil.copy((FileSystem)this.fs, (Path)srcPath, (File)dstPath, (boolean)deleteSource, (Configuration)this.fs.getConf());
    }

    @Override
    public boolean delete(String tenantCode, String hdfsFilePath, boolean recursive) throws IOException {
        return this.fs.delete(new Path(hdfsFilePath), recursive);
    }

    @Override
    public boolean exists(String tenantCode, String hdfsFilePath) throws IOException {
        return this.fs.exists(new Path(hdfsFilePath));
    }

    public FileStatus[] listFileStatus(String filePath) throws IOException {
        try {
            return this.fs.listStatus(new Path(filePath));
        }
        catch (IOException e) {
            logger.error("Get file list exception", (Throwable)e);
            throw new IOException("Get file list exception", e);
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        return this.fs.rename(new Path(src), new Path(dst));
    }

    public boolean isYarnEnabled() {
        return this.yarnEnabled;
    }

    public ExecutionStatus getApplicationStatus(String applicationId) throws BaseException {
        String result;
        String responseContent;
        if (StringUtils.isEmpty((String)applicationId)) {
            return null;
        }
        String applicationUrl = this.getApplicationUrl(applicationId);
        if (logger.isDebugEnabled()) {
            logger.debug("generate yarn application url, applicationUrl={}", (Object)applicationUrl);
        }
        String string = responseContent = Boolean.TRUE.equals(PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false)) ? KerberosHttpClient.get(applicationUrl) : HttpUtils.get(applicationUrl);
        if (responseContent != null) {
            ObjectNode jsonObject = JSONUtils.parseObject(responseContent);
            if (!jsonObject.has("app")) {
                return ExecutionStatus.FAILURE;
            }
            result = jsonObject.path("app").path("finalStatus").asText();
        } else {
            String jobHistoryUrl = this.getJobHistoryUrl(applicationId);
            if (logger.isDebugEnabled()) {
                logger.debug("generate yarn job history application url, jobHistoryUrl={}", (Object)jobHistoryUrl);
            }
            String string2 = responseContent = Boolean.TRUE.equals(PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false)) ? KerberosHttpClient.get(jobHistoryUrl) : HttpUtils.get(jobHistoryUrl);
            if (null != responseContent) {
                ObjectNode jsonObject = JSONUtils.parseObject(responseContent);
                if (!jsonObject.has("job")) {
                    return ExecutionStatus.FAILURE;
                }
                result = jsonObject.path("job").path("state").asText();
            } else {
                return ExecutionStatus.FAILURE;
            }
        }
        return this.getExecutionStatus(result);
    }

    private ExecutionStatus getExecutionStatus(String result) {
        switch (result) {
            case "ACCEPTED": {
                return ExecutionStatus.SUBMITTED_SUCCESS;
            }
            case "SUCCEEDED": 
            case "ENDED": {
                return ExecutionStatus.SUCCESS;
            }
            case "NEW": 
            case "NEW_SAVING": 
            case "SUBMITTED": 
            case "FAILED": {
                return ExecutionStatus.FAILURE;
            }
            case "KILLED": {
                return ExecutionStatus.KILL;
            }
        }
        return ExecutionStatus.RUNNING_EXECUTION;
    }

    public static String getHdfsDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH;
    }

    public static String getHdfsDir(ResourceType resourceType, String tenantCode) {
        String hdfsDir = "";
        if (resourceType.equals((Object)ResourceType.FILE)) {
            hdfsDir = HadoopUtils.getHdfsResDir(tenantCode);
        } else if (resourceType.equals((Object)ResourceType.UDF)) {
            hdfsDir = HadoopUtils.getHdfsUdfDir(tenantCode);
        }
        return hdfsDir;
    }

    @Override
    public String getDir(ResourceType resourceType, String tenantCode) {
        return HadoopUtils.getHdfsDir(resourceType, tenantCode);
    }

    public static String getHdfsResDir(String tenantCode) {
        return String.format("%s/resources", HadoopUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsUdfDir(String tenantCode) {
        return String.format("%s/udfs", HadoopUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HadoopUtils.getHdfsDir(resourceType, tenantCode), fileName);
    }

    public static String getHdfsResourceFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HadoopUtils.getHdfsResDir(tenantCode), fileName);
    }

    public static String getHdfsUdfFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HadoopUtils.getHdfsUdfDir(tenantCode), fileName);
    }

    public static String getHdfsTenantDir(String tenantCode) {
        return String.format("%s/%s", HadoopUtils.getHdfsDataBasePath(), tenantCode);
    }

    public static String getAppAddress(String appAddress, String rmHa) {
        String activeRM = YarnHAAdminUtils.getActiveRMName(rmHa);
        if (StringUtils.isEmpty((String)activeRM)) {
            return null;
        }
        String[] split1 = appAddress.split("//");
        if (split1.length != 2) {
            return null;
        }
        String start = split1[0] + "//";
        String[] split2 = split1[1].split(":");
        if (split2.length != 2) {
            return null;
        }
        String end = ":" + split2[1];
        return start + activeRM + end;
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                logger.error("Close HadoopUtils instance failed", (Throwable)e);
                throw new IOException("Close HadoopUtils instance failed", e);
            }
        }
    }

    @Override
    public void deleteTenant(String tenantCode) throws Exception {
        String tenantPath = HadoopUtils.getHdfsDataBasePath() + "/" + tenantCode;
        if (this.exists(tenantCode, tenantPath)) {
            this.delete(tenantCode, tenantPath, true);
        }
    }

    @Override
    public ResUploadType returnStorageType() {
        return ResUploadType.HDFS;
    }

    private static final class YarnHAAdminUtils
    extends RMAdminCLI {
        private YarnHAAdminUtils() {
        }

        public static String getActiveRMName(String rmIds) {
            String[] rmIdArr = rmIds.split(",");
            String yarnUrl = "http://%s:" + HADOOP_RESOURCE_MANAGER_HTTP_ADDRESS_PORT_VALUE + "/ws/v1/cluster/info";
            try {
                for (String rmId : rmIdArr) {
                    String state = YarnHAAdminUtils.getRMState(String.format(yarnUrl, rmId));
                    if (!"ACTIVE".equals(state)) continue;
                    return rmId;
                }
            }
            catch (Exception e) {
                logger.error("yarn ha application url generation failed, message:{}", (Object)e.getMessage());
            }
            return null;
        }

        public static String getRMState(String url) {
            String retStr;
            String string = retStr = Boolean.TRUE.equals(PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false)) ? KerberosHttpClient.get(url) : HttpUtils.get(url);
            if (StringUtils.isEmpty((String)retStr)) {
                return null;
            }
            ObjectNode jsonObject = JSONUtils.parseObject(retStr);
            if (!jsonObject.has("clusterInfo")) {
                return null;
            }
            return jsonObject.get("clusterInfo").path("haState").asText();
        }
    }
}

